/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpRecipient
extends NorthboundRecipient {
    private String urlCallback;
    private ConnectionConfigurationImpl<SimpleResponse, SimpleRequest> connectionBuilder;

    public HttpRecipient(Mediator mediator, String callback) {
        super(mediator);
        this.urlCallback = callback;
        this.connectionBuilder = new ConnectionConfigurationImpl();
        this.connectionBuilder.setContentType("application/json");
        this.connectionBuilder.setHttpMethod("POST");
    }

    public HttpRecipient(Mediator mediator, JSONObject object) {
        super(mediator);
        try {
            this.urlCallback = object.getString("callback");
        }
        catch (JSONException e) {
            throw new NullPointerException("callback is required");
        }
        this.connectionBuilder = new ConnectionConfigurationImpl();
        this.connectionBuilder.setContentType("application/json");
        this.connectionBuilder.setHttpMethod("POST");
    }

    public void callback(String callbackId, SnaMessage<?>[] messages) throws IOException {
        int index = 0;
        int length = messages == null ? 0 : messages.length;
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append("\"type\":\"CALLBACK\",");
        builder.append("\"callbackId\":");
        if (callbackId == null) {
            builder.append("null");
        } else {
            builder.append("\"");
            builder.append(callbackId);
            builder.append("\"");
        }
        builder.append(",\"messages\":");
        builder.append('[');
        while (index < length) {
            builder.append(index == 0 ? "" : ",");
            builder.append(messages[index].getJSON());
            ++index;
        }
        builder.append(']');
        builder.append('}');
        String uri = null;
        if (callbackId != null) {
            String separator = this.urlCallback.endsWith("/") ? "" : "/";
            uri = this.urlCallback + separator + callbackId;
        } else {
            uri = this.urlCallback;
        }
        this.connectionBuilder.setUri(uri);
        this.connectionBuilder.setContent((Object)builder.toString());
        this.connectionBuilder.setHttpMethod("POST");
        this.connectionBuilder.setContentType("application/json");
        SimpleRequest request = new SimpleRequest(this.connectionBuilder);
        request.send();
    }

    public String getJSON() {
        return "{\"callback\":\"" + this.urlCallback + "\"}";
    }
}

