/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.device.openhab.sensinact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.sensinact.gateway.device.openhab.common.ServerLocation;
import org.eclipse.sensinact.gateway.device.openhab.sensinact.OpenHabMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHabServerFinder {
    private static final Logger LOG = LoggerFactory.getLogger(OpenHabServerFinder.class);
    public static final String OPENHAB_SERVICE_TYPE_PROPERTY_NAME = "org.eclipse.sensinact.gateway.device.openhab.type";
    public static final String OPENHAB_SERVICE_NAME_PROPERTY_NAME = "org.eclipse.sensinact.gateway.device.openhab.name";
    public static final String OPENHAB_SERVICE_TYPE_PROPERTY_SUFFIXES = "org.eclipse.sensinact.gateway.device.openhab.suffixes";
    public static final String OPENHAB_SCHEME_PROPERTY_NAME = "org.eclipse.sensinact.gateway.device.openhab.scheme";
    public static final String OPENHAB_IP_PROPERTY_NAME = "org.eclipse.sensinact.gateway.device.openhab.ip";
    public static final String OPENHAB_PORT_PROPERTY_NAME = "org.eclipse.sensinact.gateway.device.openhab.port";
    public static final String DEFAULT_OPENHAB_SERVICE_TYPE = "_openhab-server._tcp.local.";
    public static final String DEFAULT_OPENHAB_SERVICE_SSL_TYPE = "_openhab-server-ssl._tcp local.";
    public static final String DEFAULT_OPENHAB_SERVICE_NAME = "openhab";
    public static final String DEFAULT_OPENHAB_SERVICE_SSL_NAME = "openhab-ssl";
    public static final String DEFAULT_OPENHAB_SCHEME = "http";
    public static final String DEFAULT_OPENHAB_SSL_SCHEME = "https";
    public static final String DEFAULT_OPENHAB_IP = "127.0.0.1";
    public static final int DEFAULT_OPENHAB_PORT = 8080;
    public static final int DEFAULT_OPENHAB_SSL_PORT = 8443;
    public static final String ACTIVATE_DISCOVERY_PROPERTY_NAME = "org.eclipse.sensinact.gateway.device.openhab.OpenHabDiscovery2.disabled";

    public static List<ServerLocation> getServerLocation(OpenHabMediator mediator, ServiceListener serviceListener) throws IOException {
        if (OpenHabServerFinder.isDiscoveryActivated(mediator)) {
            String openhabServiceType = OpenHabServerFinder.getOpenhabServiceType(mediator, null);
            String openhabServiceName = OpenHabServerFinder.getOpenhabServiceName(mediator, null);
            return OpenHabServerFinder.findServerLocationUsingDiscovery(mediator, serviceListener, openhabServiceType, openhabServiceName);
        }
        return OpenHabServerFinder.loadServerLocatioFromProperties(mediator);
    }

    private static List<ServerLocation> loadServerLocatioFromProperties(OpenHabMediator mediator) {
        ArrayList<ServerLocation> locations = new ArrayList<ServerLocation>();
        String suffixesProp = (String)mediator.getProperty(OPENHAB_SERVICE_TYPE_PROPERTY_SUFFIXES);
        if (suffixesProp != null) {
            String[] suffixes;
            for (String suffix : suffixes = suffixesProp.split(",")) {
                String openhabScheme = null;
                String openhabIP = null;
                int openhabPort = -1;
                String openhabServiceType = OpenHabServerFinder.getOpenhabServiceType(mediator, suffix);
                String prop = OPENHAB_SCHEME_PROPERTY_NAME + "." + suffix;
                String openhabSchemePropertyValue = (String)mediator.getProperty(prop);
                openhabScheme = openhabSchemePropertyValue != null ? openhabSchemePropertyValue : (DEFAULT_OPENHAB_SERVICE_SSL_TYPE.startsWith(openhabServiceType) ? DEFAULT_OPENHAB_SSL_SCHEME : DEFAULT_OPENHAB_SCHEME);
                prop = OPENHAB_IP_PROPERTY_NAME + "." + suffix;
                String openhabIPPropertyValue = (String)mediator.getProperty(prop);
                openhabIP = openhabIPPropertyValue != null ? openhabIPPropertyValue : DEFAULT_OPENHAB_IP;
                prop = OPENHAB_PORT_PROPERTY_NAME + "." + suffix;
                String openhabPortPropertyValue = (String)mediator.getProperty(prop);
                openhabPort = openhabPortPropertyValue != null ? Integer.parseInt(openhabPortPropertyValue) : (DEFAULT_OPENHAB_SERVICE_SSL_TYPE.startsWith(openhabServiceType) ? 8443 : 8080);
                locations.add(new ServerLocation(openhabScheme, openhabIP, openhabPort));
            }
        } else {
            String openhabScheme = null;
            String openhabIP = null;
            int openhabPort = -1;
            String openhabServiceType = OpenHabServerFinder.getOpenhabServiceType(mediator, null);
            String openhabSchemePropertyValue = (String)mediator.getProperty(OPENHAB_SCHEME_PROPERTY_NAME);
            openhabScheme = openhabSchemePropertyValue != null ? openhabSchemePropertyValue : (DEFAULT_OPENHAB_SERVICE_SSL_TYPE.startsWith(openhabServiceType) ? DEFAULT_OPENHAB_SSL_SCHEME : DEFAULT_OPENHAB_SCHEME);
            String openhabIPPropertyValue = (String)mediator.getProperty(OPENHAB_IP_PROPERTY_NAME);
            openhabIP = openhabIPPropertyValue != null ? openhabIPPropertyValue : DEFAULT_OPENHAB_IP;
            String openhabPortPropertyValue = (String)mediator.getProperty(OPENHAB_PORT_PROPERTY_NAME);
            openhabPort = openhabPortPropertyValue != null ? Integer.parseInt(openhabPortPropertyValue) : (DEFAULT_OPENHAB_SERVICE_SSL_TYPE.startsWith(openhabServiceType) ? 8443 : 8080);
            locations.add(new ServerLocation(openhabScheme, openhabIP, openhabPort));
        }
        return locations;
    }

    private static List<ServerLocation> findServerLocationUsingDiscovery(OpenHabMediator mediator, ServiceListener serviceListener, String openhabServiceType, String openhabServiceName) throws IOException {
        String openhabScheme = DEFAULT_OPENHAB_SERVICE_SSL_TYPE.startsWith(openhabServiceType) ? DEFAULT_OPENHAB_SSL_SCHEME : DEFAULT_OPENHAB_SCHEME;
        int openhabPort = 0;
        LOG.info("Starting openhab2 discovery...");
        JmDNS dns = JmDNS.create();
        LOG.info("...dns created...");
        dns.addServiceListener(openhabServiceType, serviceListener);
        LOG.info("...started openhab2 discovery");
        LOG.debug("...dns searching service info for type " + openhabServiceType + "...");
        ServiceInfo[] list = dns.list(openhabServiceType);
        if (list.length == 0) {
            LOG.warn("...no service info found by dns for type " + openhabServiceType);
        }
        ArrayList<ServerLocation> locations = new ArrayList<ServerLocation>();
        if (openhabServiceName != null) {
            ServiceInfo info = dns.getServiceInfo(openhabServiceType, openhabServiceName);
            if (info == null) {
                LOG.error("among the " + list.length + " found openhab2 service(s), unable to find one available with name " + openhabServiceName);
                throw new RuntimeException("unable to find any openhab2 service available with " + openhabServiceType + " type and " + openhabServiceName + " name");
            }
            openhabPort = info.getPort();
            String[] openhabHostAddresses = info.getHostAddresses();
            if (openhabHostAddresses.length == 0) {
                LOG.error("unexpected empty openhab2 host ip address");
            } else {
                if (openhabHostAddresses.length > 1) {
                    LOG.warn("unexpected more than one address for openhab2 host: {}. Several openhab2 instances running?", Arrays.asList(openhabHostAddresses));
                }
                for (String ip : info.getHostAddresses()) {
                    locations.add(new ServerLocation(openhabScheme, ip, openhabPort));
                    LOG.debug("Openhab2 binded to ip {} and port {}", (Object)ip, (Object)openhabPort);
                }
            }
        } else {
            for (ServiceInfo service : list) {
                LOG.info("...dns found openhab2 service for type " + openhabServiceType + ": " + service.getName() + " " + service);
                openhabPort = service.getPort();
                String[] openhabHostAddresses = service.getHostAddresses();
                if (openhabHostAddresses.length == 0) {
                    LOG.error("unexpected empty openhab2 host ip address");
                    continue;
                }
                if (openhabHostAddresses.length > 1) {
                    LOG.warn("unexpected more than one address for openhab2 host: {}. Several openhab2 instances running?", Arrays.asList(openhabHostAddresses));
                }
                for (String ip : service.getHostAddresses()) {
                    locations.add(new ServerLocation(openhabScheme, ip, openhabPort));
                    LOG.debug("Openhab2 binded to ip {} and port {}", (Object)ip, (Object)openhabPort);
                }
            }
        }
        return locations;
    }

    private static String getOpenhabServiceType(OpenHabMediator mediator, String suffix) {
        String prop = null;
        prop = suffix == null ? OPENHAB_SERVICE_TYPE_PROPERTY_NAME : OPENHAB_SERVICE_TYPE_PROPERTY_NAME + "." + suffix;
        String openhabServiceTypePropertyValue = (String)mediator.getProperty(prop);
        String openhabServiceType = null;
        if (openhabServiceTypePropertyValue != null) {
            openhabServiceType = openhabServiceTypePropertyValue;
            LOG.info("Openhab2 service type configurated by %s property set to %s", (Object)OPENHAB_SERVICE_TYPE_PROPERTY_NAME, (Object)openhabServiceType);
        } else {
            openhabServiceType = DEFAULT_OPENHAB_SERVICE_TYPE;
            LOG.info("No openhab2 service type configurated. Using default type: " + openhabServiceType);
        }
        return openhabServiceType;
    }

    private static String getOpenhabServiceName(OpenHabMediator mediator, String suffix) {
        String prop = null;
        prop = suffix == null ? OPENHAB_SERVICE_NAME_PROPERTY_NAME : OPENHAB_SERVICE_NAME_PROPERTY_NAME + "." + suffix;
        String openhabServiceNamePropertyValue = (String)mediator.getProperty(prop);
        String openhabServiceName = null;
        if (openhabServiceNamePropertyValue != null) {
            openhabServiceName = openhabServiceNamePropertyValue;
            LOG.info("Openhab2 service name configurated by %s property set to %s", (Object)OPENHAB_SERVICE_NAME_PROPERTY_NAME, (Object)openhabServiceName);
        } else {
            openhabServiceName = DEFAULT_OPENHAB_SERVICE_SSL_TYPE.startsWith(OpenHabServerFinder.getOpenhabServiceType(mediator, suffix)) ? DEFAULT_OPENHAB_SERVICE_SSL_NAME : DEFAULT_OPENHAB_SERVICE_NAME;
            LOG.info("No openhab2 service name configurated. Using default type: " + openhabServiceName);
        }
        return openhabServiceName;
    }

    private static boolean isDiscoveryActivated(OpenHabMediator mediator) {
        String activateDiscoveryPropertyValue = (String)mediator.getProperty(ACTIVATE_DISCOVERY_PROPERTY_NAME);
        boolean discoveryDescativated = false;
        if (activateDiscoveryPropertyValue != null) {
            discoveryDescativated = Boolean.parseBoolean(activateDiscoveryPropertyValue);
            LOG.info("Openhab2 discovery configurated by %s property set to %s", (Object)ACTIVATE_DISCOVERY_PROPERTY_NAME, (Object)discoveryDescativated);
        } else {
            LOG.info("No openhab2 discovery configurated. Default configuration is enabled...");
        }
        return !discoveryDescativated;
    }
}

