/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.Enumeration;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.ElementsProxy;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.Service;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.filtering.FilteringCollection;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.ActResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeMethod;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.core.method.SetResponse;
import org.eclipse.sensinact.gateway.core.method.SubscribeResponse;
import org.eclipse.sensinact.gateway.core.method.UnsubscribeResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractSession
implements Session {
    protected final String identifier;

    protected <N extends Nameable, E extends ElementsProxy<N>> String joinElementNames(E elements) {
        int index = 0;
        StringBuilder builder = new StringBuilder();
        Enumeration enumeration = elements.elements();
        while (enumeration.hasMoreElements()) {
            Nameable nameable = (Nameable)enumeration.nextElement();
            if (index > 0) {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(nameable.getName());
            builder.append("\"");
            ++index;
        }
        return builder.toString();
    }

    protected <T, R extends AccessMethodResponse<T>> R tatooRequestId(String requestId, R response) {
        if (response == null) {
            return null;
        }
        response.put("rid", requestId, requestId == null);
        return response;
    }

    protected <A extends AccessMethodResponse<JSONObject>> A responseFromJSONObject(Mediator mediator, String uri, String method, JSONObject object) throws Exception {
        if (object == null) {
            return (A)AccessMethodResponse.error(mediator, uri, AccessMethod.Type.valueOf(method), 404, "Not found", null);
        }
        switch (method) {
            case "ACT": {
                return (A)this.responseFromJSONObject(ActResponse.class, mediator, uri, method, object);
            }
            case "GET": {
                return (A)this.responseFromJSONObject(GetResponse.class, mediator, uri, method, object);
            }
            case "SET": {
                return (A)this.responseFromJSONObject(SetResponse.class, mediator, uri, method, object);
            }
            case "SUBSCRIBE": {
                return (A)this.responseFromJSONObject(SubscribeResponse.class, mediator, uri, method, object);
            }
            case "UNSUBSCRIBE": {
                return (A)this.responseFromJSONObject(UnsubscribeResponse.class, mediator, uri, method, object);
            }
        }
        return (A)((AccessMethodResponse)null);
    }

    protected <A extends AccessMethodResponse<JSONObject>> A responseFromJSONObject(Class<A> responseType, Mediator mediator, String uri, String method, JSONObject object) throws Exception {
        AccessMethodResponse response = null;
        if (object == null) {
            response = (AccessMethodResponse)AccessMethodResponse.error(mediator, uri, AccessMethod.Type.valueOf(method), 404, "Not found", null);
        } else {
            object.remove("type");
            object.remove("uri");
            Integer statusCode = (Integer)object.remove("statusCode");
            if (responseType != null) {
                int length;
                response = (AccessMethodResponse)responseType.getConstructor(Mediator.class, String.class, AccessMethodResponse.Status.class, Integer.TYPE).newInstance(new Object[]{mediator, uri, statusCode == 200 ? AccessMethodResponse.Status.SUCCESS : AccessMethodResponse.Status.ERROR, (int)statusCode});
                response.setResponse((JSONObject)object.remove("response"));
                response.setErrors((JSONArray)object.remove("errors"));
                String[] names = JSONObject.getNames((JSONObject)object);
                int n = length = names == null ? 0 : names.length;
                for (int index = 0; index < length; ++index) {
                    String name = names[index];
                    response.put(name, object.get(name));
                }
            }
        }
        return (A)response;
    }

    protected DescribeResponse<JSONObject> describeFromJSONObject(Mediator mediator, DescribeResponseBuilder<JSONObject> builder, DescribeMethod.DescribeType describeType, JSONObject object) {
        DescribeResponse<Object> response = null;
        if (object == null) {
            String element = describeType.name().toLowerCase();
            String first = element.substring(0, 1).toUpperCase();
            String suite = element.substring(1);
            response = AccessMethodResponse.error(mediator, builder.getPath(), describeType, 404, first + suite + " not found", null);
        } else {
            int length;
            object.remove("type");
            object.remove("uri");
            builder.setAccessMethodObjectResult((JSONObject)object.remove("response"));
            response = (DescribeResponse)builder.createAccessMethodResponse(object.optInt("statusCode") == 200 ? AccessMethodResponse.Status.SUCCESS : AccessMethodResponse.Status.ERROR);
            response.setErrors((JSONArray)object.remove("errors"));
            String[] names = JSONObject.getNames((JSONObject)object);
            int n = length = names == null ? 0 : names.length;
            for (int index = 0; index < length; ++index) {
                String name = names[index];
                response.put(name, object.get(name));
            }
        }
        return response;
    }

    public AbstractSession(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getSessionId() {
        return this.identifier;
    }

    @Override
    public Set<ServiceProvider> serviceProviders() {
        return this.serviceProviders(null);
    }

    @Override
    public Service service(String serviceProviderName, String serviceName) {
        Service service = null;
        ServiceProvider provider = this.serviceProvider(serviceProviderName);
        if (provider != null) {
            service = provider.getService(serviceName);
        }
        return service;
    }

    @Override
    public Resource resource(String serviceProviderName, String serviceName, String resourceName) {
        Resource resource = null;
        Service service = null;
        service = this.service(serviceProviderName, serviceName);
        if (service != null) {
            resource = service.getResource(resourceName);
        }
        return resource;
    }

    @Override
    public SubscribeResponse registerSessionIntent(Executable<Boolean, Void> callback, String ... resourcePath) {
        return this.registerSessionIntent(null, callback, resourcePath);
    }

    @Override
    public UnsubscribeResponse unregisterSessionIntent(String intentId) {
        return this.unregisterSessionIntent(null, intentId);
    }

    @Override
    public SubscribeResponse registerSessionAgent(MidAgentCallback callback, SnaFilter filter) {
        return this.registerSessionAgent(null, callback, filter);
    }

    @Override
    public UnsubscribeResponse unregisterSessionAgent(String agentId) {
        return this.unregisterSessionAgent(null, agentId);
    }

    @Override
    public GetResponse get(String serviceProviderId, String serviceId, String resourceId, String attributeId, Object ... args) {
        return this.get(null, serviceProviderId, serviceId, resourceId, attributeId, args);
    }

    @Override
    public SetResponse set(String serviceProviderId, String serviceId, String resourceId, String attributeId, Object parameter, Object ... args) {
        return this.set(null, serviceProviderId, serviceId, resourceId, attributeId, parameter, args);
    }

    @Override
    public ActResponse act(String serviceProviderId, String serviceId, String resourceId, Object[] parameters) {
        return this.act(null, serviceProviderId, serviceId, resourceId, parameters);
    }

    @Override
    public SubscribeResponse subscribe(String serviceProviderId, String serviceId, String resourceId, Recipient recipient, JSONArray conditions, Object ... args) {
        return this.subscribe(null, serviceProviderId, serviceId, resourceId, recipient, conditions, args);
    }

    @Override
    public SubscribeResponse subscribe(String serviceProviderId, String serviceId, String resourceId, Recipient recipient, JSONArray conditions, String policy, Object ... args) {
        return this.subscribe(null, serviceProviderId, serviceId, resourceId, recipient, conditions, policy, args);
    }

    @Override
    public SubscribeResponse subscribe(String requestId, String serviceProviderId, String serviceId, String resourceId, Recipient recipient, JSONArray conditions, Object ... args) {
        return this.subscribe(requestId, serviceProviderId, serviceId, resourceId, recipient, conditions, String.valueOf(0x100010), args);
    }

    @Override
    public UnsubscribeResponse unsubscribe(String serviceProviderId, String serviceId, String resourceId, String subscriptionId, Object ... args) {
        return this.unsubscribe(null, serviceProviderId, serviceId, resourceId, subscriptionId, args);
    }

    @Override
    public DescribeResponse<String> getAll() {
        return this.getAll(null, null, null);
    }

    @Override
    public DescribeResponse<String> getAll(FilteringCollection filterCollection) {
        return this.getAll(null, null, filterCollection);
    }

    @Override
    public DescribeResponse<String> getAll(String filter, FilteringCollection filterCollection) {
        return this.getAll(null, filter, filterCollection);
    }

    @Override
    public DescribeResponse<String> getProviders() {
        return this.getProviders(null, null);
    }

    @Override
    public DescribeResponse<String> getProviders(FilteringCollection filterCollection) {
        return this.getProviders(null, filterCollection);
    }

    @Override
    public DescribeResponse<JSONObject> getProvider(String serviceProviderId) {
        return this.getProvider(null, serviceProviderId);
    }

    @Override
    public DescribeResponse<String> getServices(String serviceProviderId) {
        return this.getServices(null, serviceProviderId, null);
    }

    @Override
    public DescribeResponse<String> getServices(String serviceProviderId, FilteringCollection filterCollection) {
        return this.getServices(null, serviceProviderId, filterCollection);
    }

    @Override
    public DescribeResponse<JSONObject> getService(String serviceProviderId, String serviceId) {
        return this.getService(null, serviceProviderId, serviceId);
    }

    @Override
    public DescribeResponse<String> getResources(String serviceProviderId, String serviceId) {
        return this.getResources(null, serviceProviderId, serviceId, null);
    }

    @Override
    public DescribeResponse<String> getResources(String serviceProviderId, String serviceId, FilteringCollection filterCollection) {
        return this.getResources(null, serviceProviderId, serviceId, filterCollection);
    }

    @Override
    public DescribeResponse<JSONObject> getResource(String serviceProviderId, String serviceId, String resourceId) {
        return this.getResource(null, serviceProviderId, serviceId, resourceId);
    }
}

