/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.message.AbstractMidCallback;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.MutableAccessNode;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInstanceRegistration
extends AbstractMidCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ModelInstanceRegistration.class);
    private boolean registered;
    private ServiceRegistration<?> instanceRegistration;
    private ModelConfiguration configuration;
    private Map<String, List<String>> observed = new HashMap<String, List<String>>();

    public ModelInstanceRegistration(String path, List<String> observed, ServiceRegistration<?> registration, ModelConfiguration configuration) {
        super(false);
        if (observed != null && !observed.isEmpty()) {
            block5: for (String obs : observed) {
                String[] obsEls = UriUtils.getUriElements((String)obs);
                int length = obsEls == null ? 0 : obsEls.length;
                String attribute = null;
                switch (length) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        attribute = "value";
                        break;
                    }
                    case 3: {
                        attribute = obsEls[2];
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                String key = obsEls[0] + "." + obsEls[1];
                List<String> list = this.observed.get(key);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.observed.put(key, list);
                }
                if (list.contains(attribute)) continue;
                list.add(attribute);
            }
        }
        Arrays.asList(ModelInstance.LOCATION_PROPERTY, ModelInstance.ICON_PROPERTY, ModelInstance.FRIENDLY_NAME_PROPERTY, ModelInstance.BRIDGE_PROPERTY).stream().forEach(p -> {
            List<String> list = this.observed.get(p);
            if (list == null) {
                list = new ArrayList<String>();
                this.observed.put((String)p, list);
            }
            if (!list.contains("value")) {
                list.add("value");
            }
        });
        this.instanceRegistration = registration;
        this.configuration = configuration;
        this.registered = true;
    }

    public void unregister() {
        this.registered = false;
        if (this.instanceRegistration != null) {
            this.instanceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(final Dictionary<String, Object> properties) {
        if (!this.registered || properties == null || properties.size() == 0 || this.instanceRegistration == null) {
            return;
        }
        ServiceRegistration<?> serviceRegistration = this.instanceRegistration;
        synchronized (serviceRegistration) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        ModelInstanceRegistration.this.instanceRegistration.setProperties(properties);
                    }
                    catch (IllegalArgumentException e) {
                        String message = e.getMessage();
                        String duplicateMessage = "Duplicate service property: ";
                        String duplicateProperty = null;
                        if (message.startsWith(duplicateMessage)) {
                            duplicateProperty = message.substring(duplicateMessage.length());
                        }
                        if (duplicateProperty != null && properties.remove(duplicateProperty) != null) {
                            ModelInstanceRegistration.this.update(properties);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> properties() {
        final Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (this.instanceRegistration == null) {
            return properties;
        }
        ServiceRegistration<?> serviceRegistration = this.instanceRegistration;
        synchronized (serviceRegistration) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServiceReference ref = null;
                    ref = ModelInstanceRegistration.this.instanceRegistration.getReference();
                    if (ref != null) {
                        String[] keys;
                        for (String key : keys = ref.getPropertyKeys()) {
                            properties.put(key, ref.getProperty(key));
                        }
                    }
                    return null;
                }
            });
        }
        return properties;
    }

    protected void updateLifecycle(ServiceProvider.LifecycleStatus status) {
        if (!this.registered) {
            return;
        }
        Dictionary<String, Object> properties = this.properties();
        properties.put("lifecycle.status", status.name());
        this.update(properties);
    }

    private final void updateObserved(String observed, Object value) {
        if (!this.registered || observed == null) {
            return;
        }
        Dictionary<String, Object> properties = this.properties();
        properties.remove(observed);
        if (observed.startsWith(ModelInstance.LOCATION_PROPERTY)) {
            String[] latlon;
            properties.remove("latitude");
            properties.remove("longitude");
            double latitude = 0.0;
            double longitude = 0.0;
            String[] stringArray = latlon = value == null ? new String[]{} : String.valueOf(value).split(":");
            if (latlon.length == 2) {
                try {
                    latitude = Double.parseDouble(latlon[0]);
                    longitude = Double.parseDouble(latlon[1]);
                    properties.put("latitude", latitude);
                    properties.put("longitude", longitude);
                }
                catch (NumberFormatException e) {
                    LOG.debug(e.getMessage());
                }
            }
        }
        if (value == null) {
            return;
        }
        properties.put(observed, value);
        this.update(properties);
    }

    public void updateContent(SnaLifecycleMessage.Lifecycle lifecycle, String uri, JSONObject initial, String type) {
        String service;
        if (!this.registered) {
            return;
        }
        String[] uriElements = UriUtils.getUriElements((String)uri);
        int length = uriElements == null ? 0 : uriElements.length;
        String string = service = length > 1 ? uriElements[1] : null;
        if (service == null) {
            return;
        }
        MutableAccessNode root = (MutableAccessNode)this.configuration.getAccessTree().getRoot();
        MutableAccessNode node = (MutableAccessNode)root.get(uri);
        if (node == null) {
            node = root;
        }
        String resource = length > 2 ? uriElements[2] : null;
        boolean added = !lifecycle.equals(SnaLifecycleMessage.Lifecycle.RESOURCE_DISAPPEARING) && !lifecycle.equals(SnaLifecycleMessage.Lifecycle.SERVICE_DISAPPEARING);
        Dictionary<String, Object> properties = this.properties();
        if (resource != null) {
            if (added) {
                this.updateResourceAppearing(service, resource, type, initial, node, properties);
            } else {
                this.updateResourceDisappearing(service, resource, node, properties);
            }
        } else {
            this.updateService(service, node, added, properties);
        }
        this.update(properties);
    }

    private final void updateResourceAppearing(String service, String resource, String type, JSONObject initial, MutableAccessNode node, Dictionary<String, Object> properties) {
        List<String> attributes;
        if (!this.registered || service == null || resource == null) {
            return;
        }
        AccessMethod.Type[] accessMethodTypes = AccessMethod.Type.values();
        int typesLength = accessMethodTypes == null ? 0 : accessMethodTypes.length;
        String serviceKey = service.concat(".resources");
        String resourceKey = service + "." + resource;
        ArrayList<String> resources = (ArrayList<String>)properties.get(serviceKey);
        if (resources == null) {
            resources = new ArrayList<String>();
            properties.put(serviceKey, resources);
        }
        if ((attributes = this.observed.get(resourceKey)) != null && !attributes.isEmpty()) {
            String name;
            Iterator<String> it = attributes.iterator();
            String string = name = initial == null ? null : initial.optString("name");
            while (it.hasNext()) {
                Object value = null;
                String attribute = it.next();
                if (attribute.equals(name) || attribute.equals("value") && resource.equals(name)) {
                    value = initial.opt("value");
                }
                if (ModelInstance.LOCATION_PROPERTY.equals(resourceKey)) {
                    String[] latlon;
                    double latitude = 0.0;
                    double longitude = 0.0;
                    String[] stringArray = latlon = value == null ? new String[]{} : String.valueOf(value).split(":");
                    if (latlon.length == 2) {
                        try {
                            latitude = Double.parseDouble(latlon[0]);
                            longitude = Double.parseDouble(latlon[1]);
                            properties.put("latitude", latitude);
                            properties.put("longitude", longitude);
                        }
                        catch (NumberFormatException e) {
                            LOG.debug(e.getMessage());
                        }
                    }
                }
                if (value == null) continue;
                properties.put(resourceKey + "." + attribute, value);
            }
        }
        resources.add(resource);
        properties.put(resourceKey.concat(".type"), type);
        for (int index = 0; index < typesLength; ++index) {
            AccessLevelOption accessLevelOption = node.getAccessLevelOption(accessMethodTypes[index]);
            properties.put(resourceKey + "." + accessMethodTypes[index].name(), accessLevelOption.getAccessLevel().getLevel());
        }
    }

    private final void updateResourceDisappearing(String service, String resource, MutableAccessNode node, Dictionary<String, Object> properties) {
        if (!this.registered || service == null || resource == null) {
            return;
        }
        AccessMethod.Type[] accessMethodTypes = AccessMethod.Type.values();
        int typesLength = accessMethodTypes == null ? 0 : accessMethodTypes.length;
        String serviceKey = service.concat(".resources");
        String resourceKey = service + "." + resource;
        List resources = (List)properties.get(serviceKey);
        if (resources != null) {
            resources.remove(resource);
        }
        properties.remove(resourceKey.concat(".type"));
        for (int index = 0; index < typesLength; ++index) {
            properties.remove(resourceKey + "." + accessMethodTypes[index].name());
        }
    }

    private final void updateService(String service, MutableAccessNode node, boolean added, Dictionary<String, Object> properties) {
        if (!this.registered || service == null) {
            return;
        }
        ArrayList<String> services = (ArrayList<String>)properties.get("services");
        if (services == null) {
            services = new ArrayList<String>();
        }
        if (added) {
            AccessMethod.Type[] accessMethodTypes = AccessMethod.Type.values();
            int typesLength = accessMethodTypes == null ? 0 : accessMethodTypes.length;
            for (int index = 0; index < typesLength; ++index) {
                AccessLevelOption accessLevelOption = node.getAccessLevelOption(accessMethodTypes[index]);
                properties.put(service + "." + accessMethodTypes[index].name(), accessLevelOption.getAccessLevel().getLevel());
            }
            services.add(service);
        } else {
            services.remove(service);
            ArrayList<String> tobeRemoved = new ArrayList<String>();
            Enumeration<String> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                if (key == null || !key.startsWith(service.concat("."))) continue;
                tobeRemoved.add(key);
            }
            Iterator iterator = tobeRemoved.iterator();
            while (iterator.hasNext()) {
                properties.remove(iterator.next());
            }
        }
        properties.put("services", services);
    }

    @Override
    public synchronized void doCallback(SnaMessage<?> message) {
        String uri = message.getPath();
        String[] uriElements = UriUtils.getUriElements((String)uri);
        switch (((SnaMessageSubType)((Object)message.getType())).getSnaMessageType()) {
            case UPDATE: {
                SnaUpdateMessage m = (SnaUpdateMessage)message;
                JSONObject notification = m.getNotification();
                String key = uriElements[1] + "." + uriElements[2];
                switch ((SnaUpdateMessage.Update)m.getType()) {
                    case ATTRIBUTE_VALUE_UPDATED: {
                        List<String> obs = this.observed.get(key);
                        if (obs == null || obs.isEmpty() || !obs.contains(uriElements[3])) break;
                        Object value = notification.opt("value");
                        this.updateObserved(key + "." + uriElements[3], value);
                        break;
                    }
                    case METADATA_VALUE_UPDATED: {
                        Object value = notification.opt("value");
                        this.updateObserved(key + "." + uriElements[3] + "." + uriElements[4], value);
                        break;
                    }
                }
                break;
            }
            case LIFECYCLE: {
                SnaLifecycleMessage l = (SnaLifecycleMessage)message;
                String type = null;
                JSONObject initial = null;
                switch ((SnaLifecycleMessage.Lifecycle)l.getType()) {
                    case RESOURCE_APPEARING: {
                        String modifiable;
                        String key = uriElements[1] + "." + uriElements[2];
                        initial = (JSONObject)((SnaLifecycleMessageImpl)l).get("initial");
                        type = ((SnaLifecycleMessageImpl)l).getNotification().optString("type");
                        ResourceConfig config = this.configuration.getResourceConfig(new ResourceDescriptor().withResourceName(uriElements[2]).withServiceName(uriElements[1]));
                        List<String> observeds = null;
                        if (config != null) {
                            observeds = config.getObserveds(uriElements[1]);
                        }
                        if (observeds != null && !observeds.isEmpty()) {
                            Iterator<String> it = observeds.iterator();
                            block17: while (it.hasNext()) {
                                String attr = null;
                                String s = it.next();
                                String[] obsEls = UriUtils.getUriElements((String)s);
                                int length = obsEls == null ? 0 : obsEls.length;
                                switch (length) {
                                    case 0: 
                                    case 1: {
                                        continue block17;
                                    }
                                    case 2: {
                                        attr = "value";
                                        break;
                                    }
                                    case 3: {
                                        attr = obsEls[2];
                                        break;
                                    }
                                    default: {
                                        continue block17;
                                    }
                                }
                                String observedKey = obsEls[0] + "." + obsEls[1];
                                List<String> list = this.observed.get(observedKey);
                                if (list == null) {
                                    list = new ArrayList<String>();
                                    this.observed.put(observedKey, list);
                                }
                                if (list.contains(attr)) continue;
                                list.add(attr);
                            }
                        }
                        String string = modifiable = initial == null ? null : String.valueOf(initial.opt("modifiable"));
                        if (modifiable != null) {
                            this.updateObserved(key + "." + "value" + "." + "modifiable", modifiable);
                        }
                    }
                    case SERVICE_APPEARING: 
                    case PROVIDER_DISAPPEARING: 
                    case RESOURCE_DISAPPEARING: 
                    case SERVICE_DISAPPEARING: {
                        this.updateContent((SnaLifecycleMessage.Lifecycle)l.getType(), uri, initial, type);
                    }
                }
                break;
            }
        }
    }
}

