/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.message.AbstractAgent;
import org.eclipse.sensinact.gateway.core.message.LocalAgent;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.remote.RemoteCore;
import org.json.JSONArray;
import org.json.JSONException;

public class LocalAgentImpl
extends AbstractAgent
implements LocalAgent {
    public static LocalAgent createAgent(Mediator mediator, MidAgentCallback callback, SnaFilter filter, String agentKey) {
        String suffix = (String)mediator.getProperty("org.eclipse.sensinact.gateway.filter.suffix");
        if (filter == null && suffix != null) {
            boolean isPattern = false;
            String sender = LocalAgentImpl.getSender(mediator, suffix);
            if (sender == null) {
                sender = "(/[^/]+)+";
                isPattern = true;
            } else {
                isPattern = LocalAgentImpl.isPattern(mediator, suffix);
            }
            boolean isComplement = LocalAgentImpl.isComplement(mediator, suffix);
            JSONArray conditions = LocalAgentImpl.getConditions(mediator, suffix);
            SnaMessage.Type[] types = LocalAgentImpl.getTypes(mediator, suffix);
            filter = new SnaFilter(mediator, sender, isPattern, isComplement, conditions);
            int length = types.length;
            for (int index = 0; index < length; ++index) {
                filter.addHandledType(types[index]);
            }
        }
        return new LocalAgentImpl(mediator, callback, filter, agentKey);
    }

    protected static JSONArray getConditions(Mediator mediator, String suffix) {
        JSONArray conditions = null;
        String conditionsStr = (String)mediator.getProperty(LocalAgentImpl.buildProperty("org.eclipse.sensinact.gateway.filter.conditions", suffix));
        if (conditionsStr == null) {
            conditions = new JSONArray();
        } else {
            try {
                conditions = new JSONArray(conditionsStr);
            }
            catch (JSONException e) {
                conditions = new JSONArray();
            }
        }
        return conditions;
    }

    protected static SnaMessage.Type[] getTypes(Mediator mediator, String suffix) {
        SnaMessage.Type[] messageTypes = null;
        String typesStr = (String)mediator.getProperty(LocalAgentImpl.buildProperty("org.eclipse.sensinact.gateway.filter.types", suffix));
        if (typesStr == null) {
            messageTypes = SnaMessage.Type.values();
        } else {
            String[] typesArray = typesStr.split(",");
            messageTypes = new SnaMessage.Type[typesArray.length];
            int length = typesArray.length;
            try {
                for (int index = 0; index < length; ++index) {
                    messageTypes[index] = SnaMessage.Type.valueOf(typesArray[index]);
                }
            }
            catch (IllegalArgumentException e) {
                messageTypes = SnaMessage.Type.values();
            }
        }
        return messageTypes;
    }

    protected static String getSender(Mediator mediator, String suffix) {
        return (String)mediator.getProperty(LocalAgentImpl.buildProperty("org.eclipse.sensinact.gateway.filter.sender", suffix));
    }

    protected static boolean isPattern(Mediator mediator, String suffix) {
        boolean isPattern = false;
        String patternStr = (String)mediator.getProperty(LocalAgentImpl.buildProperty("org.eclipse.sensinact.gateway.filter.pattern", suffix));
        if (patternStr != null) {
            isPattern = Boolean.parseBoolean(patternStr);
        }
        return isPattern;
    }

    protected static boolean isComplement(Mediator mediator, String suffix) {
        boolean isComplement = false;
        String complementStr = (String)mediator.getProperty(LocalAgentImpl.buildProperty("org.eclipse.sensinact.gateway.filter.complement", suffix));
        if (complementStr != null) {
            isComplement = Boolean.parseBoolean(complementStr);
        }
        return isComplement;
    }

    private static String buildProperty(String property, String suffix) {
        return property + "." + suffix;
    }

    protected LocalAgentImpl(Mediator mediator, MidAgentCallback callback, SnaFilter filter, String publicKey) {
        super(mediator, callback, filter, publicKey);
    }

    @Override
    public void doStart() {
        this.registerRemote();
    }

    @Override
    public void doStop() {
        if (this.callback.propagate()) {
            this.mediator.callServices(RemoteCore.class, (Executable)new Executable<RemoteCore, Void>(){

                public Void execute(RemoteCore remoteCore) throws Exception {
                    remoteCore.endpoint().unregisterAgent(LocalAgentImpl.this.callback.getName());
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRemote(RemoteCore remoteCore) {
        if (!this.callback.propagate() || remoteCore == null) {
            return;
        }
        LocalAgentImpl localAgentImpl = this;
        synchronized (localAgentImpl) {
            String identifier = this.callback.getName();
            remoteCore.endpoint().registerAgent(identifier, this.filter, this.publicKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemote() {
        if (!this.callback.propagate()) {
            return;
        }
        LocalAgentImpl localAgentImpl = this;
        synchronized (localAgentImpl) {
            this.mediator.callServices(RemoteCore.class, (Executable)new Executable<RemoteCore, Void>(){

                public Void execute(RemoteCore remoteCore) throws Exception {
                    LocalAgentImpl.this.registerRemote(remoteCore);
                    return null;
                }
            });
        }
    }

    @Override
    public String[] getAgentInterfaces() {
        return new String[]{SnaAgent.class.getName(), LocalAgent.class.getName()};
    }
}

