/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.message.AbstractMidCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;

public class ScheduledMidCallback
extends AbstractMidCallback {
    protected final Mediator mediator;
    protected Recipient recipient;
    protected final int delay;
    private Timer timer;
    protected SnaMessage<?> lastMessage;

    public ScheduledMidCallback(Mediator mediator, ErrorHandler errorHandler, Recipient recipient, long lifetime, int delay) {
        super(true);
        this.mediator = mediator;
        this.recipient = recipient;
        super.setErrorHandler(errorHandler);
        super.setTimeout(lifetime == -1L ? -1L : System.currentTimeMillis() + lifetime);
        this.delay = delay < 1000 ? 1000 : delay;
    }

    public void start() {
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        ScheduledMidCallback.this.recipient.callback(ScheduledMidCallback.this.getName(), new SnaMessage[]{ScheduledMidCallback.this.lastMessage});
                    }
                }
                catch (Exception e) {
                    int continuation = ScheduledMidCallback.this.getCallbackErrorHandler().handle(e);
                    switch (continuation) {
                        case 1: 
                        case 256: 
                        case 4096: {
                            break;
                        }
                        case 16: {
                            ScheduledMidCallback.this.stop();
                        }
                    }
                }
            }
        };
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(task, 0L, (long)this.delay);
    }

    @Override
    public void stop() {
        super.stop();
        this.timer.cancel();
        this.timer.purge();
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCallback(SnaMessage<?> message) throws MidCallbackException {
        ScheduledMidCallback scheduledMidCallback = this;
        synchronized (scheduledMidCallback) {
            this.lastMessage = message;
        }
    }

    @Override
    public String getName() {
        return this.identifier;
    }
}

