/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.props.KeysCollection;
import org.eclipse.sensinact.gateway.common.props.TypedKey;
import org.eclipse.sensinact.gateway.core.message.SnaErrorfulMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;

public interface SnaErrorMessage
extends SnaErrorfulMessage<Error> {
    public static final SnaMessage.Type TYPE = SnaMessage.Type.ERROR;

    public static enum Error implements SnaMessageSubType,
    KeysCollection
    {
        NO_ERROR,
        UPDATE_ERROR,
        RESPONSE_ERROR,
        LIFECYCLE_ERROR,
        SYSTEM_ERROR;

        final Set<TypedKey<?>> keys;

        private Error() {
            List<TypedKey<?>> list = Arrays.asList(new SnaMessage.KeysBuilder(SnaErrorMessage.class).keys());
            HashSet tmpKeys = new HashSet();
            tmpKeys.addAll(list);
            this.keys = Collections.unmodifiableSet(tmpKeys);
        }

        @Override
        public SnaMessage.Type getSnaMessageType() {
            return TYPE;
        }

        public Set<TypedKey<?>> keys() {
            return this.keys;
        }

        public TypedKey<?> key(String key) {
            TypedKey<?> typedKey2 = null;
            for (TypedKey<?> typedKey2 : this.keys) {
                if (typedKey2.equals((Object)key)) break;
                typedKey2 = null;
            }
            return typedKey2;
        }
    }
}

