/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.props.KeysCollection;
import org.eclipse.sensinact.gateway.common.props.TypedKey;
import org.eclipse.sensinact.gateway.core.message.AbstractSnaErrorfulMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.message.SnaResponseMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.ActResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeJSONResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeMethod;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeStringResponse;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.core.method.SetResponse;
import org.eclipse.sensinact.gateway.core.method.SubscribeResponse;
import org.eclipse.sensinact.gateway.core.method.UnknownAccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.UnsubscribeResponse;

public abstract class AccessMethodResponse<T>
extends AbstractSnaErrorfulMessage<Response>
implements SnaResponseMessage<T, Response> {
    public static final int SUCCESS_CODE = 200;
    protected final Status status;

    public static final <T, R extends AccessMethodResponse<T>> R error(Mediator mediator, String uri, AccessMethod.Type type, int statusCode, String message, Throwable throwable) {
        return AccessMethodResponse.error(mediator, uri, type.name(), statusCode, message, throwable);
    }

    private static final <T, R extends AccessMethodResponse<T>> R error(Mediator mediator, String uri, String method, int statusCode, String message, Throwable throwable) {
        int code = statusCode == 200 ? 520 : statusCode;
        AccessMethodResponse response = null;
        switch (method) {
            case "ACT": {
                response = new ActResponse(uri, Status.ERROR, code);
                break;
            }
            case "GET": {
                response = new GetResponse(uri, Status.ERROR, code);
                break;
            }
            case "SET": {
                response = new SetResponse(uri, Status.ERROR, code);
                break;
            }
            case "SUBSCRIBE": {
                response = new SubscribeResponse(uri, Status.ERROR, code);
                break;
            }
            case "UNSUBSCRIBE": {
                response = new UnsubscribeResponse(uri, Status.ERROR, code);
                break;
            }
            default: {
                try {
                    DescribeMethod.DescribeType t = DescribeMethod.DescribeType.valueOf(method);
                    response = AccessMethodResponse.error(mediator, uri, t, statusCode, message, throwable);
                    break;
                }
                catch (Exception e) {
                    response = new UnknownAccessMethodResponse(uri);
                }
            }
        }
        if (response != null && message != null) {
            response.setErrors(message, throwable);
        }
        return (R)response;
    }

    public static final <T, R extends DescribeResponse<T>> R error(Mediator mediator, String uri, DescribeMethod.DescribeType describeType, int statusCode, String message, Throwable throwable) {
        int code = statusCode == 200 ? 520 : statusCode;
        DescribeMethod.DescribeType type = describeType == null ? DescribeMethod.DescribeType.COMPLETE_LIST : describeType;
        DescribeResponse response = null;
        switch (type) {
            case COMPLETE_LIST: 
            case PROVIDERS_LIST: 
            case SERVICES_LIST: 
            case RESOURCES_LIST: {
                response = new DescribeStringResponse(uri, Status.ERROR, code, type);
                break;
            }
            case PROVIDER: 
            case SERVICE: 
            case RESOURCE: {
                response = new DescribeJSONResponse(uri, Status.ERROR, code, type);
                break;
            }
        }
        if (response != null && message != null) {
            response.setErrors(message, throwable);
        }
        return (R)response;
    }

    protected AccessMethodResponse(String uri, Response type, Status status) {
        this(uri, type, status, status == Status.SUCCESS ? 200 : 520);
    }

    protected AccessMethodResponse(String uri, Response type, Status status, int statusCode) {
        super(uri, type);
        this.status = status;
        super.putValue("statusCode", (Object)statusCode);
    }

    public void setResponse(T resultObject) {
        if (resultObject == null) {
            return;
        }
        super.putValue("response", resultObject);
    }

    @Override
    public T getResponse() {
        return (T)super.get("response");
    }

    public Status getStatus() {
        return this.status;
    }

    public int getStatusCode() {
        return (Integer)super.get("statusCode");
    }

    public int setStatusCode(int statusCode) {
        if (this.status == Status.ERROR) {
            super.putValue("statusCode", (Object)statusCode);
        }
        return (Integer)super.get("statusCode");
    }

    public static enum Status {
        ERROR,
        SUCCESS;

    }

    public static enum Response implements SnaMessageSubType,
    KeysCollection
    {
        DESCRIBE_RESPONSE,
        GET_RESPONSE,
        SET_RESPONSE,
        ACT_RESPONSE,
        SUBSCRIBE_RESPONSE,
        UNSUBSCRIBE_RESPONSE,
        UNKNOWN_METHOD_RESPONSE;

        final Set<TypedKey<?>> keys;

        private Response() {
            List<TypedKey<?>> list = Arrays.asList(new SnaMessage.KeysBuilder(AccessMethodResponse.class).keys());
            HashSet tmpKeys = new HashSet();
            tmpKeys.addAll(list);
            this.keys = Collections.unmodifiableSet(tmpKeys);
        }

        @Override
        public SnaMessage.Type getSnaMessageType() {
            return SnaResponseMessage.TYPE;
        }

        public Set<TypedKey<?>> keys() {
            return this.keys;
        }

        public TypedKey<?> key(String key) {
            TypedKey<?> typedKey2 = null;
            for (TypedKey<?> typedKey2 : this.keys) {
                if (typedKey2.equals((Object)key)) break;
                typedKey2 = null;
            }
            return typedKey2;
        }
    }
}

