/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueTypeException;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.common.primitive.Primitive;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.JSONUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameter
extends Primitive
implements JSONable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Parameter.class);
    public static final String FIXED_PARAMETER_KEY = "fixed";
    protected boolean fixed = false;
    protected Object fixedValue = null;
    protected List<Constraint> constraints;

    public Parameter(Mediator mediator, String name, Class<?> type) throws InvalidValueException {
        super(mediator, name, type);
        this.fixed = false;
        this.fixedValue = null;
        this.constraints = Collections.emptyList();
    }

    public Parameter(Mediator mediator, String name, Class<?> type, List<Constraint> constraints) throws InvalidValueException {
        super(mediator, name, type);
        this.fixed = false;
        this.fixedValue = null;
        this.constraints = Collections.unmodifiableList(new ArrayList<Constraint>(constraints));
    }

    public Parameter(Mediator mediator, String name, Class<?> type, Object value) throws InvalidValueException {
        super(mediator, name, type, value);
        this.fixed = true;
        this.fixedValue = value;
        this.constraints = Collections.emptyList();
    }

    public Parameter(Mediator mediator, JSONObject parameter) throws InvalidValueException {
        super(mediator, parameter);
        this.fixed = parameter.optBoolean(FIXED_PARAMETER_KEY);
        if (this.fixed) {
            this.fixedValue = parameter.opt("value");
            this.constraints = Collections.emptyList();
        } else {
            this.fixedValue = null;
            JSONArray constraints = parameter.optJSONArray("constraints");
            ArrayList<Constraint> constraintList = new ArrayList<Constraint>();
            int length = constraints == null ? 0 : constraints.length();
            try {
                for (int index = 0; index < length; ++index) {
                    JSONObject constraintJSON = constraints.getJSONObject(index);
                    Constraint constraint = ConstraintFactory.Loader.load((ClassLoader)this.mediator.getClassLoader(), (JSONObject)constraintJSON);
                    constraintList.add(constraint);
                }
            }
            catch (InvalidConstraintDefinitionException e) {
                throw new InvalidValueException((Throwable)e);
            }
            this.constraints = Collections.unmodifiableList(constraintList);
        }
    }

    public boolean validParameter(Parameter parameter, boolean strict) {
        boolean complies = this.validParameter(parameter.getValue()) && (!strict || super.getName().equals(parameter.getName()));
        return complies;
    }

    public boolean validParameter(Parameter parameter) {
        return this.validParameter(parameter, false);
    }

    public boolean validParameter(JSONObject jsonParameter) {
        try {
            Parameter parameter = new Parameter(this.mediator, jsonParameter);
            this.validParameter(parameter, false);
        }
        catch (InvalidValueException e) {
            return false;
        }
        return true;
    }

    public boolean validParameter(Object parameter) {
        if (Modifiable.FIXED.equals((Object)this.getModifiable())) {
            return true;
        }
        if (parameter == null || parameter.getClass().isArray() && parameter.getClass().getComponentType() == Object.class) {
            return true;
        }
        for (Constraint constraint : this.constraints) {
            if (constraint.complies(parameter)) continue;
            return false;
        }
        try {
            super.setValue(parameter);
        }
        catch (InvalidValueException e) {
            return false;
        }
        return true;
    }

    public Modifiable getModifiable() {
        return !this.fixed ? Modifiable.UPDATABLE : Modifiable.FIXED;
    }

    public void reset() {
        if (Modifiable.FIXED.equals((Object)this.getModifiable())) {
            return;
        }
        try {
            super.setValue(this.fixedValue);
        }
        catch (InvalidValueException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getJSON() {
        JSONObject description = this.getJSONObject();
        if (String.class == this.getType() || this.getType().isPrimitive()) {
            description.put("value", this.getValue());
        } else {
            description.put("value", (Object)JSONUtils.toJSONFormat((Object)this.getValue()));
        }
        return description.toString();
    }

    protected final JSONObject getJSONObject() {
        JSONObject description = new JSONObject();
        description.put("name", (Object)this.name);
        String typeName = CastUtils.writeClass((Class)this.type);
        description.put("type", (Object)typeName);
        description.put(FIXED_PARAMETER_KEY, this.fixed);
        JSONArray constraints = new JSONArray();
        for (Constraint constraint : this.constraints) {
            constraints.put((Object)new JSONObject(constraint.getJSON()));
        }
        description.put("constraints", (Object)constraints);
        return description;
    }

    protected final void checkType(Class<?> type) throws InvalidValueTypeException {
        if (Object.class != type && Object[].class != type && !Recipient.class.isAssignableFrom(type) && !Set.class.isAssignableFrom(type)) {
            super.checkType(type);
        }
    }

    protected void beforeChange(Object value) throws InvalidValueException {
    }

    protected void afterChange(Object value) throws InvalidValueException {
    }

    public Object clone() {
        try {
            if (this.constraints.isEmpty()) {
                if (this.fixed) {
                    return new Parameter(this.mediator, this.name, this.type, this.fixedValue);
                }
                return new Parameter(this.mediator, this.name, this.type);
            }
            return new Parameter(this.mediator, this.name, this.type, this.constraints);
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
            return null;
        }
    }
}

