/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shortcut
extends Signature {
    private static final Logger LOG = LoggerFactory.getLogger(Shortcut.class);
    private final Map<Integer, Parameter> fixedParameters;
    private final Stack<Shortcut> shortucts;

    public Shortcut(Mediator mediator, AccessMethod.Type type, Class<?>[] parameterTypes, String[] parameterNames, Map<Integer, Parameter> fixedParameters) throws InvalidValueException {
        super(mediator, type, parameterTypes, parameterNames);
        this.fixedParameters = Collections.unmodifiableMap(fixedParameters);
        this.shortucts = new Stack();
    }

    public Shortcut(Mediator mediator, String methodType, Parameter[] parameters, Map<Integer, Parameter> fixedParameters) throws InvalidValueException {
        super(mediator, methodType, parameters);
        this.fixedParameters = Collections.unmodifiableMap(fixedParameters);
        this.shortucts = new Stack();
    }

    public Shortcut(Mediator mediator, String name, AccessMethodResponse.Response returnedType, Parameter[] parameters, Map<Integer, Parameter> fixedParameters) throws InvalidValueException {
        super(mediator, name, returnedType, parameters);
        this.fixedParameters = Collections.unmodifiableMap(fixedParameters);
        this.shortucts = new Stack();
    }

    public void push(Shortcut shortcut) {
        if (shortcut == null) {
            return;
        }
        this.shortucts.push(shortcut);
    }

    public Map<Integer, Parameter> getFixedParameters() {
        return this.fixedParameters;
    }

    @Override
    public Object[] values() {
        int position = 0;
        HashMap<Integer, Parameter> gathered = new HashMap<Integer, Parameter>();
        while (!this.shortucts.isEmpty()) {
            gathered.putAll(this.shortucts.pop().getFixedParameters());
        }
        gathered.putAll(this.fixedParameters);
        Object[] values = new Object[super.length() + gathered.size()];
        Iterator<Parameter> iterator = super.iterator();
        Parameter parameter = null;
        while (position < values.length) {
            parameter = (Parameter)gathered.get(position);
            if (parameter == null && iterator.hasNext()) {
                parameter = iterator.next();
            }
            values[position] = parameter.getValue();
            ++position;
        }
        return values;
    }

    @Override
    public Object clone() {
        try {
            return new Shortcut(this.mediator, this.name, this.returnedType, this.parameters, this.fixedParameters);
        }
        catch (InvalidValueException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

