/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.logic;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.eclipse.sensinact.gateway.app.api.exception.NotAReadableResourceException;
import org.eclipse.sensinact.gateway.app.api.exception.ResourceNotFoundException;
import org.eclipse.sensinact.gateway.app.api.exception.ServiceNotFoundException;
import org.eclipse.sensinact.gateway.app.api.function.DataItf;
import org.eclipse.sensinact.gateway.app.basic.logic.ConditionFunction;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.BundleContext;

public class BetweenFunction
extends ConditionFunction {
    private static final String JSON_SCHEMA = "between.json";

    public static JSONObject getJSONSchemaFunction(BundleContext context) {
        try {
            return new JSONObject(new JSONTokener((Reader)new InputStreamReader(context.getBundle().getResource("/between.json").openStream())));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Boolean testCondition(List<DataItf> datas) throws NotAReadableResourceException, ResourceNotFoundException, ServiceNotFoundException {
        boolean result = false;
        double variable = (Double)CastUtils.castPrimitive(Double.TYPE, (Object)datas.get(0).getValue());
        double lowerLimit = (Double)CastUtils.castPrimitive(Double.TYPE, (Object)datas.get(1).getValue());
        double higherLimit = (Double)CastUtils.castPrimitive(Double.TYPE, (Object)datas.get(2).getValue());
        if (variable >= lowerLimit && variable <= higherLimit) {
            result = true;
        }
        return result;
    }
}

