/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.StructuredPacket;
import org.eclipse.sensinact.gateway.generic.packet.SubPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoPacketWrapper<P extends Packet>
implements StructuredPacket,
SubPacket {
    private static final Logger LOG = LoggerFactory.getLogger(PojoPacketWrapper.class);
    private P packet;
    protected AnnotatedElement attributeIDAnnotated = null;
    protected AnnotatedElement commandIDAnnotated = null;
    protected AnnotatedElement dataAnnotated = null;
    protected AnnotatedElement iterationAnnotated = null;
    protected AnnotatedElement metadataIDAnnotated = null;
    protected AnnotatedElement profileIDAnnotated = null;
    protected AnnotatedElement resourceIDAnnotated = null;
    protected AnnotatedElement serviceIDAnnotated = null;
    protected AnnotatedElement serviceProviderIDAnnotated = null;
    protected AnnotatedElement timestampAnnotated = null;
    protected AnnotatedElement helloMessageAnnotated = null;
    protected AnnotatedElement goodbyeMessageAnnotated = null;
    private final PojoPacketExecutable<Boolean> iteration = new PojoPacketExecutable("iterationAnnotated");
    private final PojoPacketExecutable<Task.CommandType> commandExtractor = new PojoPacketExecutable("commandIDAnnotated");
    private final PojoPacketExecutable<Boolean> isGoodByeMessageExtractor = new PojoPacketExecutable("goodbyeMessageAnnotated");
    private final PojoPacketExecutable<Boolean> isHelloMessageExtractor = new PojoPacketExecutable("helloMessageAnnotated");
    private final PojoPacketExecutable<String> profileIdExtractor = new PojoPacketExecutable("profileIDAnnotated");
    private final PojoPacketExecutable<String> serviceProviderIdExtractor = new PojoPacketExecutable("serviceProviderIDAnnotated");
    private final PojoPacketExecutable<String> serviceIdExtractor = new PojoPacketExecutable("serviceIDAnnotated");
    private final PojoPacketExecutable<String> resourceIdExtractor = new PojoPacketExecutable("resourceIDAnnotated");
    private final PojoPacketExecutable<String> attributeIdExtractor = new PojoPacketExecutable("attributeIDAnnotated");
    private final PojoPacketExecutable<String> metadataIdExtractor = new PojoPacketExecutable("metadataIDAnnotated");
    private final PojoPacketExecutable<Long> timestampExtractor = new PojoPacketExecutable("timestampAnnotated");
    private final PojoPacketExecutable<Object> dataExtractor = new PojoPacketExecutable("dataAnnotated");

    public void wrap(P packet) {
        this.packet = packet;
    }

    @Override
    public byte[] getBytes() {
        return this.packet.getBytes();
    }

    @Override
    public Iterator<SubPacket> iterator() {
        return new Iterator<SubPacket>(){
            boolean last = false;

            @Override
            public boolean hasNext() {
                return !this.last;
            }

            @Override
            public SubPacket next() {
                try {
                    this.last = (Boolean)PojoPacketWrapper.this.iteration.execute(PojoPacketWrapper.this.packet);
                }
                catch (Exception e) {
                    this.last = true;
                }
                return PojoPacketWrapper.this;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Task.CommandType getCommand() {
        try {
            return this.commandExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public boolean isHelloMessage() {
        try {
            Boolean hello = this.isHelloMessageExtractor.execute(this.packet);
            if (hello == null) {
                return false;
            }
            return hello;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public boolean isGoodbyeMessage() {
        try {
            Boolean goodbye = this.isGoodByeMessageExtractor.execute(this.packet);
            if (goodbye == null) {
                return false;
            }
            return goodbye;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public String getProfileId() {
        try {
            return this.profileIdExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public String getServiceProviderId() {
        try {
            return this.serviceProviderIdExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public String getServiceId() {
        try {
            return this.serviceIdExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public String getResourceId() {
        try {
            return this.resourceIdExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public String getAttributeId() {
        try {
            return this.attributeIdExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public String getMetadataId() {
        try {
            return this.metadataIdExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public Object getData() {
        try {
            return this.dataExtractor.execute(this.packet);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public long getTimestamp() {
        try {
            Long l = this.timestampExtractor.execute(this.packet);
            if (l == null) {
                return -1L;
            }
            return l;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            return -1L;
        }
    }

    private final class PojoPacketExecutable<T>
    implements Executable<P, T> {
        private Field annotated;

        PojoPacketExecutable(String annotated) {
            try {
                this.annotated = PojoPacketWrapper.class.getDeclaredField(annotated);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }

        public T execute(P packet) throws Exception {
            this.annotated.setAccessible(true);
            Object value = this.annotated.get(PojoPacketWrapper.this);
            if (value != null) {
                if (Method.class.isAssignableFrom(value.getClass())) {
                    ((Method)value).setAccessible(true);
                    return (T)((Method)value).invoke(packet, new Object[0]);
                }
                if (Field.class.isAssignableFrom(value.getClass())) {
                    ((Field)value).setAccessible(true);
                    return (T)((Field)value).get(packet);
                }
            }
            return null;
        }
    }
}

