/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.smpl;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskUrlConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpChildTaskConfigurationDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTaskConfigurationDescription;

class ChainedHttpTaskConfigurator
extends SimpleTaskConfigurator {
    private Deque<Link> chain = new LinkedList<Link>();

    public ChainedHttpTaskConfigurator(SimpleHttpProtocolStackEndpoint endpoint, String profile, Task.CommandType command, HttpTaskUrlConfigurator urlBuilder, HttpTaskConfigurationDescription annotation, List<HttpChildTaskConfigurationDescription> chain) {
        super(endpoint, null, command, urlBuilder, annotation);
        int length;
        int n = length = chain == null ? 0 : chain.size();
        for (int index = 0; index < length; ++index) {
            SimpleTaskConfigurator executable = new SimpleTaskConfigurator(endpoint, profile, command, urlBuilder, annotation, chain.get(index));
            this.chain.addLast(new Link(chain.get(index).getIdentifier(), executable));
        }
    }

    @Override
    public <T extends HttpTask<?, ?>> void configure(T task) throws Exception {
        if (!HttpChainedTasks.class.isAssignableFrom(task.getClass())) {
            super.configure(task);
            return;
        }
        try {
            HttpChainedTasks chained = (HttpChainedTasks)task;
            for (Link link : this.chain) {
                String subTask = chained.addChainedTask(link.identifier);
                HttpTaskProcessingContext context = this.endpoint.createChainedContext(link.configurator, chained, subTask);
                if (context == null) continue;
                this.endpoint.getMediator().registerProcessingContext((HttpTask<?, ?>)((Object)subTask), context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final class Link
    implements Nameable {
        public final String identifier;
        public final SimpleTaskConfigurator configurator;

        Link(String identifier, SimpleTaskConfigurator configurator) {
            this.identifier = identifier;
            this.configurator = configurator;
        }

        public String getName() {
            return this.identifier;
        }
    }
}

