/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal.KodiRequestPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.kodi.osgi.KodiServiceMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KodiRemoteControlHttpListener
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(KodiRemoteControlHttpListener.class);
    SimpleHttpProtocolStackEndpoint connector;
    KodiServiceMediator mediator;

    public KodiRemoteControlHttpListener(SimpleHttpProtocolStackEndpoint connector, KodiServiceMediator mediator) {
        this.connector = connector;
        this.mediator = mediator;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String key;
        if (LOG.isDebugEnabled()) {
            LOG.debug(resp.toString());
        }
        if ((key = req.getParameter("key")) == null) {
            resp.sendError(400, "Missing parameter 'key'");
            return;
        }
        String serviceProvider = this.mediator.getKodiFriendlyName(req.getRemoteAddr());
        if (serviceProvider == null) {
            resp.sendError(400, "Wrong service provider");
            return;
        }
        try {
            long timestamp = System.currentTimeMillis();
            this.connector.process((Packet)new KodiRequestPacket(serviceProvider, "buttonpressed", "remote-control", key));
            this.connector.process((Packet)new KodiRequestPacket(serviceProvider, "buttonpressed", "lastevent", timestamp));
        }
        catch (InvalidPacketException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

