/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.temperature.generator.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.parser.DeviceInfo;

public class DataParser {
    private Mediator mediator;
    private static Set<String> found;

    public DataParser(Mediator mediator) {
        this.mediator = mediator;
    }

    public Set<DeviceInfo> createDeviceInfosSet(int number) {
        found = new HashSet<String>();
        HashSet<DeviceInfo> deviceInfoSet = new HashSet<DeviceInfo>();
        try {
            for (int i = 0; i < number; ++i) {
                DeviceInfo deviceInfo = null;
                while (deviceInfo == null) {
                    deviceInfo = DataParser.choose(this.mediator, i);
                }
                deviceInfoSet.add(deviceInfo);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        found.clear();
        found = null;
        return deviceInfoSet;
    }

    private static BufferedReader buildReader(Mediator mediator) throws IOException {
        return new BufferedReader(new InputStreamReader(mediator.getContext().getBundle().getResource("data.csv").openStream()));
    }

    private static DeviceInfo choose(Mediator mediator, int nb) throws IOException {
        DeviceInfo deviceInfo;
        DeviceInfo result = null;
        Random rand = new Random();
        BufferedReader reader = DataParser.buildReader(mediator);
        Integer sleepTimeRandom = new Random().nextInt(10000) + 1000;
        String currentLine = null;
        int n = nb;
        while (true) {
            if ((currentLine = reader.readLine()) == null) {
                reader.close();
                reader = null;
                reader = DataParser.buildReader(mediator);
                currentLine = reader.readLine();
                n = nb;
            }
            if (n == 0 || rand.nextInt(n) != 0) {
                ++n;
                continue;
            }
            if (!found.contains(String.valueOf(n - nb))) break;
            ++n;
        }
        found.add(String.valueOf(n - nb));
        String[] splittedLine = currentLine.split(",");
        double[] temperatures = new double[12];
        for (int i = 0; i < 12; ++i) {
            temperatures[i] = Double.parseDouble(splittedLine[i + 2]);
        }
        result = deviceInfo = new DeviceInfo(String.valueOf(nb), splittedLine[1] + ":" + splittedLine[2], temperatures, sleepTimeRandom.intValue());
        reader.close();
        reader = null;
        return result;
    }
}

