/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.fan.osgi;

import java.util.Collections;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.simulated.fan.internal.FanConfig;
import org.eclipse.sensinact.gateway.simulated.fan.swing.FanPanel;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends AbstractActivator<Mediator> {
    private static final String GUI_ENABLED = "org.eclipse.sensinact.simulated.gui.enabled";
    private LocalProtocolStackEndpoint<Packet> connector;
    private ExtModelConfiguration<Packet> manager;
    private FanConfig config;
    private FanPanel fanPanel;

    public void doStart() throws Exception {
        this.config = new FanConfig();
        if (this.manager == null) {
            this.manager = ExtModelConfigurationBuilder.instance((Mediator)this.mediator).withStartAtInitializationTime(true).build(new Object[]{"fan-resource.xml", Collections.emptyMap()});
        }
        if (this.connector == null) {
            this.connector = new LocalProtocolStackEndpoint(this.mediator);
            this.connector.addInjectableInstance(FanConfig.class, (Object)this.config);
        }
        this.connector.connect(this.manager);
        if ("true".equals(this.mediator.getProperty(GUI_ENABLED))) {
            this.fanPanel = new FanPanel(this.mediator);
            this.config.addListener(this.fanPanel);
        }
    }

    public void doStop() throws Exception {
        this.connector.stop();
        if (this.fanPanel != null) {
            this.config.removeListener(this.fanPanel);
            this.fanPanel.stop();
        }
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }
}

