/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.DefaultNorthboundRequestHandler;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestBuilder;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestHandler;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NorthboundAccess<W extends NorthboundRequestWrapper> {
    private static final Logger LOG = LoggerFactory.getLogger(NorthboundAccess.class);
    protected W request;
    protected NorthboundMediator mediator;

    protected abstract boolean respond(NorthboundMediator var1, NorthboundRequestBuilder var2) throws IOException;

    protected abstract void sendError(int var1, String var2) throws IOException;

    public static byte[] compress(String stringContent) throws IOException {
        if (stringContent != null && stringContent.length() > 0) {
            ByteArrayOutputStream byteArrayOutputstream = new ByteArrayOutputStream();
            GZIPOutputStream compressContent = new GZIPOutputStream(byteArrayOutputstream);
            compressContent.write(stringContent.getBytes("UTF-8"));
            compressContent.close();
            return byteArrayOutputstream.toByteArray();
        }
        return null;
    }

    public NorthboundAccess(W request) throws IOException {
        this.request = request;
        this.mediator = request.getMediator();
        if (this.mediator == null) {
            this.sendError(500, "Unable to process the request");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceed() throws IOException {
        NorthboundRequestHandler.NorthboundResponseBuildError buildError = null;
        NorthboundRequestBuilder builder = null;
        DefaultNorthboundRequestHandler dnrh = new DefaultNorthboundRequestHandler();
        dnrh.init((NorthboundRequestWrapper)this.request);
        if (dnrh.processRequestURI()) {
            builder = dnrh.handle();
            if (builder == null) {
                buildError = dnrh.getBuildError();
            }
        } else {
            try {
                Collection references = this.mediator.getContext().getServiceReferences(NorthboundRequestHandler.class, null);
                for (ServiceReference reference : references) {
                    block15: {
                        NorthboundRequestHandler handler = null;
                        if (reference != null && (handler = (NorthboundRequestHandler)this.mediator.getContext().getService(reference)) != null) {
                            try {
                                handler.init((NorthboundRequestWrapper)this.request, Arrays.stream(AccessMethod.Type.values()).collect(HashSet::new, Set::add, Set::addAll));
                                if (!handler.processRequestURI() || (builder = handler.handle()) != null) break block15;
                                buildError = handler.getBuildError();
                                break;
                            }
                            catch (IOException e) {
                                LOG.error(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                this.mediator.getContext().ungetService(reference);
                            }
                        }
                    }
                    if (builder == null) continue;
                    break;
                }
            }
            catch (InvalidSyntaxException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (builder == null) {
            if (buildError == null) {
                this.sendError(400, "Invalid request");
            } else {
                this.sendError(buildError.status, buildError.message);
            }
            return;
        }
        this.respond(this.mediator, builder);
    }

    public void destroy() {
        LOG.debug("Destroying NorthboundAccess '%s'", (Object)this.request.getRequestURI());
    }
}

