/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.antlr.impl;

import java.util.function.Predicate;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.AbstractCriterion;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.IStringValue;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.LdapComparator;

public abstract class AbstractProviderCriterion
extends AbstractCriterion {
    private final String ldapConstantName;
    private final IStringValue expectedValue;
    private final LdapComparator comparator;

    public AbstractProviderCriterion(String ldapConstantName, IStringValue expectedValue, LdapComparator comparator) {
        this.ldapConstantName = ldapConstantName;
        this.expectedValue = expectedValue;
        this.comparator = comparator;
    }

    protected abstract String getProviderFieldValue(ProviderSnapshot var1);

    public String toString() {
        String content = String.format("(%s%s%s)", new Object[]{this.ldapConstantName, this.comparator, this.expectedValue});
        if (this.isNegative()) {
            content = String.format("(!%s)", content);
        }
        return content;
    }

    @Override
    public Predicate<ProviderSnapshot> getProviderFilter() {
        boolean approxMatch;
        boolean bl = approxMatch = this.comparator == LdapComparator.APPROX;
        if (this.isNegative()) {
            return p -> !this.expectedValue.matches(this.getProviderFieldValue((ProviderSnapshot)p), approxMatch);
        }
        return p -> this.expectedValue.matches(this.getProviderFieldValue((ProviderSnapshot)p), approxMatch);
    }
}

