/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.impl;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.security.UserInfo;
import org.eclipse.sensinact.northbound.security.api.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    @Context
    Application application;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null) {
            if (!this.application.getProperties().getOrDefault("raw.anonymous.access", Boolean.FALSE).booleanValue()) {
                requestContext.abortWith(this.unauthorizedResponse());
            }
        } else {
            String credential;
            String userid;
            Authenticator.Scheme authScheme;
            String[] headerChunks = authHeader.split(" ", 2);
            if (headerChunks.length != 2) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            }
            if ("Bearer".equals(headerChunks[0])) {
                authScheme = Authenticator.Scheme.TOKEN;
                userid = null;
                credential = headerChunks[1];
            } else if ("Basic".equals(headerChunks[0])) {
                authScheme = Authenticator.Scheme.USER_PASSWORD;
                String cred = new String(Base64.getMimeDecoder().decode(headerChunks[1]), StandardCharsets.UTF_8);
                String[] credChunks = cred.split(":", 2);
                userid = credChunks[0];
                credential = credChunks[1];
            } else {
                authScheme = null;
                userid = null;
                credential = null;
            }
            Optional<UserInfo> user = this.getAuthenticators().stream().filter((? super T a) -> a.getScheme() == authScheme).map(a -> this.tryAuth((Authenticator)a, userid, credential)).filter((? super T u) -> u != null).findFirst();
            if (user.isEmpty()) {
                requestContext.abortWith(this.unauthorizedResponse());
            } else {
                requestContext.setSecurityContext((SecurityContext)new UserInfoSecurityContext(Authenticator.Scheme.TOKEN.getHttpScheme(), user.get()));
            }
        }
    }

    private Response unauthorizedResponse() {
        Collection<Authenticator> authenticators = this.getAuthenticators();
        if (authenticators.isEmpty()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)this.getAuthHeader(authenticators)).build();
    }

    private String getAuthHeader(Collection<Authenticator> authenticators) {
        return authenticators.stream().map(a -> String.format("%s realm=%s", a.getScheme().getHttpScheme(), a.getRealm())).collect(Collectors.joining(", "));
    }

    private Collection<Authenticator> getAuthenticators() {
        return this.application.getProperties().getOrDefault("authentication.providers", Set.of());
    }

    private UserInfo tryAuth(Authenticator a, String user, String credential) {
        UserInfo ui = null;
        try {
            ui = a.authenticate(user, credential);
        }
        catch (Exception e) {
            LOG.warn("Failed to authenticate user {}", (Object)user, (Object)e);
        }
        return ui;
    }

    private static class UserInfoSecurityContext
    implements SecurityContext {
        private final String scheme;
        private final UserInfoPrincipal principal;

        public UserInfoSecurityContext(String scheme, UserInfo info) {
            this.scheme = scheme;
            this.principal = new UserInfoPrincipal(info);
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return true;
        }

        public String getAuthenticationScheme() {
            return this.scheme;
        }
    }

    public static class UserInfoPrincipal
    implements Principal {
        private final UserInfo info;

        public UserInfoPrincipal(UserInfo info) {
            this.info = info;
        }

        @Override
        public String getName() {
            return this.info.getUserId();
        }

        public UserInfo getUserInfo() {
            return this.info;
        }
    }
}

