/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.impl;

import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.security.Principal;
import org.eclipse.sensinact.core.security.UserInfo;
import org.eclipse.sensinact.core.session.SensiNactSession;
import org.eclipse.sensinact.core.session.SensiNactSessionManager;
import org.eclipse.sensinact.northbound.rest.impl.AuthenticationFilter;

@Provider
public class SensinactSessionProvider
implements ContextResolver<SensiNactSession> {
    @Context
    Application application;
    @Context
    SecurityContext context;

    public SensiNactSession getContext(Class<?> type) {
        SensiNactSessionManager manager = (SensiNactSessionManager)this.application.getProperties().get("session.manager");
        Principal principal = this.context.getUserPrincipal();
        if (principal instanceof AuthenticationFilter.UserInfoPrincipal) {
            AuthenticationFilter.UserInfoPrincipal uiPrincipal = (AuthenticationFilter.UserInfoPrincipal)principal;
            return manager.getDefaultSession(uiPrincipal.getUserInfo());
        }
        if (principal == null) {
            return manager.getDefaultSession(UserInfo.ANONYMOUS);
        }
        throw new IllegalArgumentException("Unable to establish user context");
    }
}

