/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.ws.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.sensinact.core.security.UserInfo;
import org.eclipse.sensinact.core.session.SensiNactSessionManager;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.ws.impl.WebSocketEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketCreator
implements JettyWebSocketCreator {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketCreator.class);
    private final List<WebSocketEndpoint> sessions = Collections.synchronizedList(new ArrayList());
    private final SensiNactSessionManager sessionManager;
    private final IQueryHandler queryHandler;

    public WebSocketCreator(SensiNactSessionManager sessionManager, IQueryHandler queryHandler) {
        this.sessionManager = sessionManager;
        this.queryHandler = queryHandler;
    }

    public void deleteSocketEndpoint(WebSocketEndpoint wsEndpoint) {
        if (this.sessions.remove(wsEndpoint)) {
            wsEndpoint.close();
        }
    }

    public void close() {
        for (WebSocketEndpoint session : this.sessions) {
            try {
                session.close();
            }
            catch (Throwable t) {
                logger.error("Error closing websocket: {}", (Object)t.getMessage(), (Object)t);
            }
        }
        this.sessions.clear();
    }

    public Object createWebSocket(JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) {
        UserInfo userInfo = (UserInfo)req.getServletAttribute("sensinact.user.info");
        WebSocketEndpoint wsConnection = new WebSocketEndpoint(this, this.sessionManager.createNewSession(userInfo), this.queryHandler);
        this.sessions.add(wsConnection);
        return wsConnection;
    }
}

