/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.IndependentCommands;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.extract.impl.BulkGenericDtoDataExtractor;
import org.eclipse.sensinact.core.extract.impl.CustomDtoDataExtractor;
import org.eclipse.sensinact.core.extract.impl.DataExtractor;
import org.eclipse.sensinact.core.extract.impl.GenericDtoDataExtractor;
import org.eclipse.sensinact.core.impl.SaveProviderCommand;
import org.eclipse.sensinact.core.impl.SetMetadataCommand;
import org.eclipse.sensinact.core.impl.SetValueCommand;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.promise.Promise;

@Component
public class DataUpdateImpl
implements DataUpdate {
    @Reference
    GatewayThread thread;
    private final Map<Class<?>, DataExtractor> cachedExtractors = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<?> pushUpdate(Object o) {
        DataExtractor extractor;
        if (o instanceof Provider) {
            return this.thread.execute((AbstractSensinactCommand)new SaveProviderCommand((Provider)o));
        }
        Class<?> updateClazz = o.getClass();
        Map<Class<?>, DataExtractor> map = this.cachedExtractors;
        synchronized (map) {
            extractor = this.cachedExtractors.computeIfAbsent(updateClazz, this::createDataExtractor);
        }
        List<? extends AbstractUpdateDto> updates = extractor.getUpdates(o);
        return this.thread.execute((AbstractSensinactCommand)new IndependentCommands(updates.stream().map(this::toCommand).collect(Collectors.toList())));
    }

    private DataExtractor createDataExtractor(Class<?> clazz) {
        if (clazz == GenericDto.class) {
            return new GenericDtoDataExtractor();
        }
        if (clazz == BulkGenericDto.class) {
            return new BulkGenericDtoDataExtractor();
        }
        return new CustomDtoDataExtractor(clazz);
    }

    private AbstractSensinactCommand<Void> toCommand(AbstractUpdateDto dto) {
        if (dto instanceof DataUpdateDto) {
            return new SetValueCommand((DataUpdateDto)dto);
        }
        if (dto instanceof MetadataUpdateDto) {
            return new SetMetadataCommand((MetadataUpdateDto)dto);
        }
        throw new IllegalArgumentException("Unknown dto type " + dto.getClass().toString());
    }
}

