/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.core.model.ResourceBuilder;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.ServiceBuilder;
import org.eclipse.sensinact.core.model.impl.ModelImpl;
import org.eclipse.sensinact.core.model.impl.NestableBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ResourceBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ServiceImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;

public class ServiceBuilderImpl<P>
extends NestableBuilderImpl<P, ModelImpl, Service>
implements ServiceBuilder<P> {
    private final String name;
    private final ModelNexus nexusImpl;
    private final List<NestableBuilderImpl<?, ServiceImpl, ?>> nested = new ArrayList();
    private Instant creationTimestamp;

    public ServiceBuilderImpl(AtomicBoolean active, P parent, ModelImpl built, String name, ModelNexus nexusImpl) {
        super(active, parent, built);
        this.name = name;
        this.nexusImpl = nexusImpl;
    }

    public ServiceBuilder<P> exclusivelyOwned(boolean exclusive) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public ServiceBuilder<P> withAutoDeletion(boolean autoDelete) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public ServiceBuilder<P> withCreationTime(Instant creationTime) {
        this.checkValid();
        this.creationTimestamp = creationTime;
        return this;
    }

    public ResourceBuilder<ServiceBuilder<P>, Object> withResource(String name) {
        this.checkValid();
        ResourceBuilderImpl<ServiceBuilder<P>, Object> rb = new ResourceBuilderImpl<ServiceBuilder<P>, Object>(this.active, this, null, name, this.nexusImpl);
        this.nested.add(rb);
        return rb;
    }

    @Override
    protected Service doBuild(ModelImpl builtParent) {
        this.checkValid();
        ServiceImpl s = new ServiceImpl(this.active, builtParent, this.nexusImpl.createService(builtParent.getModelEClass(), this.name, this.creationTimestamp == null ? Instant.now() : this.creationTimestamp), this.nexusImpl);
        this.nested.forEach(n -> n.doBuild(s));
        return s;
    }
}

