/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.ResourceBuilder;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.impl.ResourceBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ResourceImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;

public class ServiceImpl
extends CommandScopedImpl
implements Service {
    private final Model model;
    private final EReference service;
    private final ModelNexus nexusImpl;

    public ServiceImpl(AtomicBoolean active, Model model, EReference service, ModelNexus nexusImpl) {
        super(active);
        this.model = model;
        this.service = service;
        this.nexusImpl = nexusImpl;
    }

    public String getName() {
        this.checkValid();
        return this.service.getName();
    }

    public boolean isExclusivelyOwned() {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public boolean isAutoDelete() {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public ResourceBuilder<Resource, Object> createResource(String resource) {
        this.checkValid();
        return new ResourceBuilderImpl(this.active, null, this, resource, this.nexusImpl);
    }

    public Map<String, ? extends Resource> getResources() {
        this.checkValid();
        return this.nexusImpl.getResourcesForService(this.getServiceEClass()).collect(Collectors.toMap(f -> f.getName(), f -> new ResourceImpl(this.active, this, (ETypedElement)f)));
    }

    public Model getModel() {
        this.checkValid();
        return this.model;
    }

    EClass getServiceEClass() {
        return this.service.getEReferenceType();
    }
}

