/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.notification.impl;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.notification.ResourceActionNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.core.notification.impl.AbstractNotificationAccumulatorImpl;
import org.osgi.service.typedevent.TypedEventBus;

public class ImmediateNotificationAccumulator
extends AbstractNotificationAccumulatorImpl
implements NotificationAccumulator {
    private final TypedEventBus eventBus;

    public ImmediateNotificationAccumulator(TypedEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void addProvider(String model, String name) {
        LifecycleNotification ln = this.createLifecycleNotification(LifecycleNotification.Status.PROVIDER_CREATED, model, name, null, null, null, null);
        this.eventBus.deliver(ln.getTopic(), (Object)ln);
    }

    public void removeProvider(String model, String name) {
        LifecycleNotification ln = this.createLifecycleNotification(LifecycleNotification.Status.PROVIDER_DELETED, model, name, null, null, null, null);
        this.eventBus.deliver(ln.getTopic(), (Object)ln);
    }

    public void addService(String model, String provider, String name) {
        LifecycleNotification ln = this.createLifecycleNotification(LifecycleNotification.Status.SERVICE_CREATED, model, provider, name, null, null, null);
        this.eventBus.deliver(ln.getTopic(), (Object)ln);
    }

    public void removeService(String model, String provider, String name) {
        LifecycleNotification ln = this.createLifecycleNotification(LifecycleNotification.Status.SERVICE_DELETED, model, provider, name, null, null, null);
        this.eventBus.deliver(ln.getTopic(), (Object)ln);
    }

    public void addResource(String model, String provider, String service, String name) {
        LifecycleNotification ln = this.createLifecycleNotification(LifecycleNotification.Status.RESOURCE_CREATED, model, provider, service, name, null, null);
        this.eventBus.deliver(ln.getTopic(), (Object)ln);
    }

    public void removeResource(String model, String provider, String service, String name) {
        LifecycleNotification ln = this.createLifecycleNotification(LifecycleNotification.Status.RESOURCE_DELETED, model, provider, service, name, null, null);
        this.eventBus.deliver(ln.getTopic(), (Object)ln);
    }

    public void metadataValueUpdate(String model, String provider, String service, String resource, Map<String, Object> oldValues, Map<String, Object> newValues, Instant timestamp) {
        Map<String, Object> nonNullOldValues = oldValues == null ? Collections.emptyMap() : oldValues;
        Map<String, Object> nonNullNewValues = newValues == null ? Collections.emptyMap() : newValues;
        Objects.requireNonNull(timestamp);
        ResourceMetaDataNotification rmn = this.createResourceMetaDataNotification(model, provider, service, resource, nonNullOldValues, nonNullNewValues, timestamp);
        this.eventBus.deliver(rmn.getTopic(), (Object)rmn);
    }

    public void resourceValueUpdate(String model, String provider, String service, String resource, Class<?> type, Object oldValue, Object newValue, Instant timestamp) {
        Objects.requireNonNull(timestamp);
        ResourceDataNotification rdn = this.createResourceDataNotification(model, provider, service, resource, type, oldValue, newValue, timestamp);
        this.eventBus.deliver(rdn.getTopic(), (Object)rdn);
    }

    public void resourceAction(String model, String provider, String service, String resource, Instant timestamp) {
        Objects.requireNonNull(timestamp);
        ResourceActionNotification ran = this.createResourceActionNotification(model, provider, service, resource, timestamp);
        this.eventBus.deliver(ran.getTopic(), (Object)ran);
    }

    @Override
    protected void doComplete() {
    }
}

