/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.launcher.integration;

import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.gateway.launcher.integration.InputStreamConsumer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class FeatureLaunchingIntegrationTest {
    private static Process OSGI_PROCESS;
    private static Thread outputThread;

    FeatureLaunchingIntegrationTest() {
    }

    @BeforeAll
    static void startServer() throws Exception {
        String javaCmd = ProcessHandle.current().info().command().orElse("java");
        OSGI_PROCESS = new ProcessBuilder(javaCmd, "-Dsensinact.config.dir=src/it/resources/config", "-jar", "target/export.jar").redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start();
        outputThread = new Thread(new InputStreamConsumer(OSGI_PROCESS.getInputStream()));
        outputThread.start();
    }

    @AfterAll
    static void stopServer() throws Exception {
        try {
            OutputStream stream = OSGI_PROCESS.getOutputStream();
            stream.write("exit 0\n".getBytes(StandardCharsets.UTF_8));
            stream.flush();
            OSGI_PROCESS.waitFor(5L, TimeUnit.SECONDS);
        }
        finally {
            if (OSGI_PROCESS.isAlive()) {
                OSGI_PROCESS.destroyForcibly();
            }
        }
        outputThread.join(1000L);
    }

    @Test
    void testHttp() throws Exception {
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:8081")).GET().build();
        for (int i = 0; i < 10; ++i) {
            if (!OSGI_PROCESS.isAlive()) {
                Assertions.fail((String)"Server process lost");
            }
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                Assertions.assertEquals((int)404, (int)response.statusCode());
                return;
            }
            catch (ConnectException | HttpConnectTimeoutException timeout) {
                Thread.sleep(1000L);
                continue;
            }
        }
        Assertions.fail((String)"Did not contact the server");
    }
}

