/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.mqtt.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class PEMUtils {
    private static final String DEFAULT_KEY_ALG = "RSA";

    public static Certificate loadCertificate(InputStream inSteam) throws CertificateException {
        return PEMUtils.loadCertificate(inSteam, "X.509");
    }

    public static Certificate loadCertificate(InputStream inSteam, String type) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance(type);
        return factory.generateCertificate(inSteam);
    }

    public static PrivateKey loadPrivateKey(InputStream inStream) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return PEMUtils.loadPrivateKey(new String(inStream.readAllBytes()));
    }

    public static PrivateKey loadPrivateKey(String pemContent) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String tmpAlgorithm;
        if (pemContent == null || pemContent.isBlank()) {
            throw new InvalidKeySpecException("No key given");
        }
        String beginMarker = "-----BEGIN ";
        int beginIdx = pemContent.indexOf("-----BEGIN ");
        if (beginIdx == -1) {
            throw new InvalidKeySpecException("Key had no BEGIN marker");
        }
        String beginEOLMarker = " PRIVATE KEY-----";
        int endOfLineIdx = pemContent.indexOf(" PRIVATE KEY-----", beginIdx);
        if (endOfLineIdx == -1) {
            throw new InvalidKeySpecException("Key had an invalid BEGIN marker");
        }
        int algorithmIdx = beginIdx + "-----BEGIN ".length();
        String algorithm = algorithmIdx >= endOfLineIdx ? DEFAULT_KEY_ALG : ((tmpAlgorithm = pemContent.substring(algorithmIdx, endOfLineIdx).strip()).isEmpty() ? DEFAULT_KEY_ALG : tmpAlgorithm);
        int keyStartIdx = endOfLineIdx + " PRIVATE KEY-----".length();
        int keyEndIdx = pemContent.indexOf("-----END ", keyStartIdx);
        if (keyEndIdx == -1) {
            throw new InvalidKeySpecException("Key have no END marker");
        }
        String b64key = pemContent.substring(keyStartIdx, keyEndIdx).strip().replaceAll("[\r\n ]", "");
        byte[] rawKey = Base64.getDecoder().decode(b64key);
        return PEMUtils.loadPrivateKey(rawKey, algorithm);
    }

    public static PrivateKey loadPrivateKey(InputStream inStream, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return PEMUtils.loadPrivateKey(new String(inStream.readAllBytes()), algorithm);
    }

    public static PrivateKey loadPrivateKey(String pemContent, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (pemContent == null || pemContent.isBlank()) {
            throw new InvalidKeySpecException("No key given");
        }
        if (algorithm == null || algorithm.isBlank()) {
            return PEMUtils.loadPrivateKey(pemContent);
        }
        String b64key = pemContent.replaceAll("-----[\\-]+-----", "").replaceAll("[\r\n ]", "");
        byte[] rawKey = Base64.getDecoder().decode(b64key);
        return PEMUtils.loadPrivateKey(rawKey, algorithm);
    }

    public static PrivateKey loadPrivateKey(byte[] pkcs8key, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(pkcs8key);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(ks);
    }
}

