/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.IndependentCommands;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.dto.impl.FailedMappingDto;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.extract.impl.BulkGenericDtoDataExtractor;
import org.eclipse.sensinact.core.extract.impl.CustomDtoDataExtractor;
import org.eclipse.sensinact.core.extract.impl.DataExtractor;
import org.eclipse.sensinact.core.extract.impl.GenericDtoDataExtractor;
import org.eclipse.sensinact.core.impl.SaveProviderCommand;
import org.eclipse.sensinact.core.impl.SetMetadataCommand;
import org.eclipse.sensinact.core.impl.SetValueCommand;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.push.DataMappingException;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.DataUpdateException;
import org.eclipse.sensinact.core.push.FailedUpdatesException;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.promise.FailedPromisesException;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class DataUpdateImpl
implements DataUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(DataUpdateImpl.class);
    @Reference
    GatewayThread thread;
    private final Map<Class<?>, DataExtractor> cachedExtractors = new WeakHashMap();

    public Promise<?> pushUpdate(Object o) {
        return this.doPushUpdate(o).recoverWith(p -> this.thread.getPromiseFactory().failed((Throwable)new FailedUpdatesException(this.toStreamOfDataUpdateFailures(p.getFailure()))));
    }

    private Stream<DataUpdateException> toStreamOfDataUpdateFailures(Throwable t) {
        if (t instanceof DataUpdateException) {
            return Stream.of((DataUpdateException)t);
        }
        if (t instanceof FailedUpdatesException) {
            return ((FailedUpdatesException)t).getFailedUpdates().stream();
        }
        if (t instanceof FailedPromisesException) {
            return ((FailedPromisesException)t).getFailedPromises().stream().flatMap(p -> {
                try {
                    return this.toStreamOfDataUpdateFailures(p.getFailure());
                }
                catch (InterruptedException e) {
                    LOG.error("An InterruptedException occurred getting failures from completed promises", (Throwable)e);
                    return Stream.empty();
                }
            });
        }
        LOG.error("An unexpected exception type occurred getting failures from data updates", t);
        return Stream.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Promise<?> doPushUpdate(Object o) {
        DataExtractor extractor;
        if (o instanceof Provider) {
            return this.thread.execute((AbstractSensinactCommand)new SaveProviderCommand((Provider)o));
        }
        Class<?> updateClazz = o.getClass();
        Map<Class<?>, DataExtractor> map = this.cachedExtractors;
        synchronized (map) {
            extractor = this.cachedExtractors.computeIfAbsent(updateClazz, this::createDataExtractor);
        }
        List<? extends AbstractUpdateDto> updates = extractor.getUpdates(o);
        return this.thread.execute((AbstractSensinactCommand)new IndependentCommands(updates.stream().map(this::toCommand).collect(Collectors.toList())));
    }

    private DataExtractor createDataExtractor(Class<?> clazz) {
        if (clazz == GenericDto.class) {
            return new GenericDtoDataExtractor();
        }
        if (clazz == BulkGenericDto.class) {
            return new BulkGenericDtoDataExtractor();
        }
        return new CustomDtoDataExtractor(clazz);
    }

    private AbstractSensinactCommand<Void> toCommand(AbstractUpdateDto dto) {
        if (dto instanceof DataUpdateDto) {
            return new SetValueCommand((DataUpdateDto)dto);
        }
        if (dto instanceof MetadataUpdateDto) {
            return new SetMetadataCommand((MetadataUpdateDto)dto);
        }
        if (dto instanceof FailedMappingDto) {
            return new FailureCommand((FailedMappingDto)dto);
        }
        throw new IllegalArgumentException("Unknown dto type " + dto.getClass().toString());
    }

    static class FailureCommand
    extends AbstractSensinactCommand<Void> {
        private final FailedMappingDto dto;

        public FailureCommand(FailedMappingDto dto) {
            this.dto = dto;
        }

        protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
            return promiseFactory.failed((Throwable)new DataMappingException(this.dto.modelPackageUri, this.dto.model, this.dto.provider, this.dto.service, this.dto.resource, this.dto.originalDto, this.dto.mappingFailure));
        }
    }
}

