/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.typedevent.bus.impl;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.aries.typedevent.bus.impl.EventConverter;
import org.apache.aries.typedevent.bus.impl.EventTask;
import org.apache.aries.typedevent.bus.impl.MonitorEventTask;
import org.apache.aries.typedevent.bus.impl.TypedEventMonitorImpl;
import org.apache.aries.typedevent.bus.impl.TypedEventTask;
import org.apache.aries.typedevent.bus.impl.UnhandledEventTask;
import org.apache.aries.typedevent.bus.impl.UntypedEventTask;
import org.osgi.annotation.bundle.Capabilities;
import org.osgi.annotation.bundle.Capability;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.typedevent.TypedEventBus;
import org.osgi.service.typedevent.TypedEventHandler;
import org.osgi.service.typedevent.UnhandledEventHandler;
import org.osgi.service.typedevent.UntypedEventHandler;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.TypeReference;

@Capabilities(value={@Capability(namespace="osgi.service", attribute={"objectClass:List<String>=org.osgi.service.typedevent.TypedEventBus"}, uses={TypedEventBus.class}), @Capability(namespace="osgi.implementation", name="osgi.typedevent", version="1.0.0", uses={TypedEventBus.class})})
public class TypedEventBusImpl
implements TypedEventBus {
    private static final TypeReference<List<String>> LIST_OF_STRINGS = new TypeReference<List<String>>(){};
    private final Object lock = new Object();
    private final TypedEventMonitorImpl monitorImpl;
    private final Map<String, Map<TypedEventHandler<?>, Filter>> topicsToTypedHandlers = new HashMap();
    private final NavigableMap<String, Map<TypedEventHandler<?>, Filter>> wildcardTopicsToTypedHandlers = new TreeMap();
    private final Map<TypedEventHandler<?>, Class<?>> typedHandlersToTargetClasses = new HashMap();
    private final NavigableMap<String, Map<UntypedEventHandler, Filter>> topicsToUntypedHandlers = new TreeMap<String, Map<UntypedEventHandler, Filter>>();
    private final Map<String, Map<UntypedEventHandler, Filter>> wildcardTopicsToUntypedHandlers = new HashMap<String, Map<UntypedEventHandler, Filter>>();
    private final List<UnhandledEventHandler> unhandledEventHandlers = new ArrayList<UnhandledEventHandler>();
    private final Map<Long, List<String>> knownHandlers = new HashMap<Long, List<String>>();
    private final Map<Long, TypedEventHandler<?>> knownTypedHandlers = new HashMap();
    private final Map<Long, UntypedEventHandler> knownUntypedHandlers = new HashMap<Long, UntypedEventHandler>();
    private final BlockingQueue<EventTask> queue = new LinkedBlockingQueue<EventTask>();
    private EventThread thread;
    private final Object threadLock = new Object();

    public TypedEventBusImpl(TypedEventMonitorImpl monitorImpl, Map<String, ?> config) {
        this.monitorImpl = monitorImpl;
    }

    void addTypedEventHandler(Bundle registeringBundle, TypedEventHandler<?> handler, Map<String, Object> properties) {
        Class<?> clazz = this.discoverTypeForTypedHandler(registeringBundle, handler, properties);
        String defaultTopic = clazz == null ? null : clazz.getName().replace(".", "/");
        this.doAddEventHandler(this.topicsToTypedHandlers, this.wildcardTopicsToTypedHandlers, this.knownTypedHandlers, handler, defaultTopic, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> discoverTypeForTypedHandler(Bundle registeringBundle, TypedEventHandler<?> handler, Map<String, Object> properties) {
        Class<?> clazz = null;
        Object type = properties.get("event.type");
        if (type != null) {
            try {
                clazz = registeringBundle.loadClass(String.valueOf(type));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            Class<?> toCheck = handler.getClass();
            while (clazz == null && (clazz = this.findDirectlyImplemented(toCheck)) == null && (clazz = this.processInterfaceHierarchyForClass(toCheck)) == null) {
                toCheck = toCheck.getSuperclass();
            }
        }
        if (clazz != null) {
            Object object = this.lock;
            synchronized (object) {
                this.typedHandlersToTargetClasses.put(handler, clazz);
            }
        }
        return clazz;
    }

    private Class<?> processInterfaceHierarchyForClass(Class<?> toCheck) {
        Class<?> iface;
        Class<?> clazz = null;
        Class<?>[] classArray = toCheck.getInterfaces();
        int n = classArray.length;
        for (int i = 0; i < n && (clazz = this.findDirectlyImplemented(iface = classArray[i])) == null && (clazz = this.processInterfaceHierarchyForClass(iface)) == null; ++i) {
        }
        return clazz;
    }

    private Class<?> findDirectlyImplemented(Class<?> toCheck) {
        return Arrays.stream(toCheck.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(t -> TypedEventHandler.class.equals((Object)t.getRawType())).map(t -> t.getActualTypeArguments()[0]).findFirst().map(Class.class::cast).orElse(null);
    }

    void addUntypedEventHandler(UntypedEventHandler handler, Map<String, Object> properties) {
        this.doAddEventHandler(this.topicsToUntypedHandlers, this.wildcardTopicsToUntypedHandlers, this.knownUntypedHandlers, handler, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void doAddEventHandler(Map<String, Map<T, Filter>> map, Map<String, Map<T, Filter>> wildcardMap, Map<Long, T> idMap, T handler, String defaultTopic, Map<String, Object> properties) {
        Filter f;
        List topicList;
        Object prop = properties.get("event.topics");
        if (prop == null) {
            if (defaultTopic == null) {
                return;
            }
            topicList = Collections.singletonList(defaultTopic);
        } else {
            topicList = (List)Converters.standardConverter().convert(prop).to(LIST_OF_STRINGS);
        }
        topicList = topicList.stream().filter(s -> {
            String msg = TypedEventBusImpl.checkTopicSyntax(s, true);
            if (msg != null) {
                // empty if block
            }
            return msg == null;
        }).collect(Collectors.toList());
        Long serviceId = this.getServiceId(properties);
        try {
            f = this.getFilter(serviceId, properties);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.knownHandlers.put(serviceId, topicList);
            idMap.put(serviceId, handler);
            for (String s2 : topicList) {
                String topicToUse;
                Map<String, Map<T, Filter>> mapToUse;
                if (TypedEventBusImpl.isWildcard(s2)) {
                    mapToUse = wildcardMap;
                    topicToUse = s2.length() == 1 ? "" : s2.substring(0, s2.length() - 2);
                } else {
                    mapToUse = map;
                    topicToUse = s2;
                }
                Map handlers = mapToUse.computeIfAbsent(topicToUse, x1 -> new HashMap());
                handlers.put(handler, f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTypedEventHandler(TypedEventHandler<?> handler, Map<String, Object> properties) {
        Long serviceId = this.getServiceId(properties);
        this.doRemoveEventHandler(this.topicsToTypedHandlers, this.wildcardTopicsToTypedHandlers, this.knownTypedHandlers, handler, serviceId);
        Object object = this.lock;
        synchronized (object) {
            this.typedHandlersToTargetClasses.remove(handler);
        }
    }

    void removeUntypedEventHandler(UntypedEventHandler handler, Map<String, Object> properties) {
        Long serviceId = this.getServiceId(properties);
        this.doRemoveEventHandler(this.topicsToUntypedHandlers, this.wildcardTopicsToUntypedHandlers, this.knownUntypedHandlers, handler, serviceId);
    }

    private Long getServiceId(Map<String, Object> properties) {
        return (Long)Converters.standardConverter().convert(properties.get("service.id")).to(Long.class);
    }

    private Filter getFilter(Long serviceId, Map<String, Object> properties) throws IllegalArgumentException {
        String key = "event.filter";
        return this.getFilter(serviceId, key, properties.get(key));
    }

    private Filter getFilter(Long serviceId, String key, Object o) throws IllegalArgumentException {
        if (o == null || "".equals(o)) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter((String)String.valueOf(o));
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException("The filter associated with property " + key + "for service with id " + serviceId + " is invalid", ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, U> void doRemoveEventHandler(Map<String, Map<T, U>> map, Map<String, Map<T, U>> wildcardMap, Map<Long, T> idMap, T handler, Long serviceId) {
        Object object = this.lock;
        synchronized (object) {
            List<String> consumed = this.knownHandlers.remove(serviceId);
            idMap.remove(serviceId);
            if (consumed != null) {
                consumed.forEach(s -> {
                    String key;
                    Map handlers;
                    if (TypedEventBusImpl.isWildcard(s)) {
                        handlers = wildcardMap;
                        key = s.length() == 1 ? "" : s.substring(0, s.length() - 2);
                    } else {
                        handlers = map;
                        key = s;
                    }
                    Map subMap = (Map)handlers.get(key);
                    if (subMap != null) {
                        subMap.remove(handler);
                        if (subMap.isEmpty()) {
                            map.remove(key);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatedTypedEventHandler(Bundle registeringBundle, Map<String, Object> properties) {
        TypedEventHandler<?> handler;
        Long serviceId = this.getServiceId(properties);
        Object object = this.lock;
        synchronized (object) {
            handler = this.knownTypedHandlers.get(serviceId);
        }
        Class<?> clazz = this.discoverTypeForTypedHandler(registeringBundle, handler, properties);
        String defaultTopic = clazz == null ? null : clazz.getName().replace(".", "/");
        this.doUpdatedEventHandler(this.topicsToTypedHandlers, this.wildcardTopicsToTypedHandlers, this.knownTypedHandlers, defaultTopic, properties);
    }

    void updatedUntypedEventHandler(Map<String, Object> properties) {
        this.doUpdatedEventHandler(this.topicsToUntypedHandlers, this.wildcardTopicsToUntypedHandlers, this.knownUntypedHandlers, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void doUpdatedEventHandler(Map<String, Map<T, Filter>> map, Map<String, Map<T, Filter>> wildcardMap, Map<Long, T> idToHandler, String defaultTopic, Map<String, Object> properties) {
        Long serviceId = this.getServiceId(properties);
        Object object = this.lock;
        synchronized (object) {
            T handler = idToHandler.get(serviceId);
            this.doRemoveEventHandler(map, wildcardMap, idToHandler, handler, serviceId);
            this.doAddEventHandler(map, wildcardMap, idToHandler, handler, defaultTopic, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnhandledEventHandler(UnhandledEventHandler handler, Map<String, Object> properties) {
        Object object = this.lock;
        synchronized (object) {
            this.unhandledEventHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUnhandledEventHandler(UnhandledEventHandler handler, Map<String, Object> properties) {
        Object object = this.lock;
        synchronized (object) {
            this.unhandledEventHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        EventThread thread = new EventThread();
        Object object = this.threadLock;
        synchronized (object) {
            this.thread = thread;
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        EventThread thread;
        Object object = this.threadLock;
        synchronized (object) {
            thread = this.thread;
            this.thread = null;
        }
        thread.shutdown();
        try {
            thread.join(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.monitorImpl.destroy();
    }

    public void deliver(Object event) {
        Objects.requireNonNull(event, "The event object must not be null");
        String topicName = event.getClass().getName().replace('.', '/');
        this.deliver(topicName, event);
    }

    public void deliver(String topic, Object event) {
        TypedEventBusImpl.checkTopicSyntax(topic);
        Objects.requireNonNull(event, "The event object must not be null");
        this.deliver(topic, EventConverter.forTypedEvent(event));
    }

    public void deliverUntyped(String topic, Map<String, ?> eventData) {
        TypedEventBusImpl.checkTopicSyntax(topic);
        Objects.requireNonNull(eventData, "The event object must not be null");
        this.deliver(topic, EventConverter.forUntypedEvent(eventData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver(String topic, EventConverter convertibleEventData) {
        List<EventTask> deliveryTasks;
        Object object = this.lock;
        synchronized (object) {
            List<EventTask> typedDeliveries = this.toTypedEventTasks(this.topicsToTypedHandlers.getOrDefault(topic, Collections.emptyMap()), topic, convertibleEventData);
            List<EventTask> untypedDeliveries = this.toUntypedEventTasks(this.topicsToUntypedHandlers.getOrDefault(topic, Collections.emptyMap()), topic, convertibleEventData);
            ArrayList<EventTask> wildcardDeliveries = new ArrayList<EventTask>();
            String truncatedTopic = topic;
            do {
                int idx;
                truncatedTopic = (idx = truncatedTopic.lastIndexOf(47)) > 0 ? truncatedTopic.substring(0, idx) : "";
                wildcardDeliveries.addAll(this.toTypedEventTasks(this.wildcardTopicsToTypedHandlers.getOrDefault(truncatedTopic, Collections.emptyMap()), topic, convertibleEventData));
                wildcardDeliveries.addAll(this.toUntypedEventTasks(this.wildcardTopicsToUntypedHandlers.getOrDefault(truncatedTopic, Collections.emptyMap()), topic, convertibleEventData));
            } while (truncatedTopic.length() > 0);
            deliveryTasks = new ArrayList<EventTask>(typedDeliveries.size() + untypedDeliveries.size() + wildcardDeliveries.size());
            deliveryTasks.addAll(typedDeliveries);
            deliveryTasks.addAll(untypedDeliveries);
            deliveryTasks.addAll(wildcardDeliveries);
            if (deliveryTasks.isEmpty()) {
                System.out.println("Unhandled Event Handlers are being used for event sent to topic " + topic);
                deliveryTasks = this.unhandledEventHandlers.stream().map(handler -> new UnhandledEventTask(topic, convertibleEventData, (UnhandledEventHandler)handler)).collect(Collectors.toList());
            }
        }
        this.queue.add(new MonitorEventTask(topic, convertibleEventData, this.monitorImpl));
        this.queue.addAll(deliveryTasks);
    }

    private List<EventTask> toTypedEventTasks(Map<TypedEventHandler<?>, Filter> map, String topic, EventConverter convertibleEventData) {
        ArrayList<EventTask> list = new ArrayList<EventTask>();
        for (Map.Entry<TypedEventHandler<?>, Filter> e : map.entrySet()) {
            Filter f = e.getValue();
            if (f != null && !convertibleEventData.applyFilter(f)) continue;
            TypedEventHandler<?> handler = e.getKey();
            list.add(new TypedEventTask(topic, convertibleEventData, handler, this.typedHandlersToTargetClasses.get(handler)));
        }
        return list;
    }

    private List<EventTask> toUntypedEventTasks(Map<UntypedEventHandler, Filter> map, String topic, EventConverter convertibleEventData) {
        ArrayList<EventTask> list = new ArrayList<EventTask>();
        for (Map.Entry<UntypedEventHandler, Filter> e : map.entrySet()) {
            Filter f = e.getValue();
            if (f != null && !convertibleEventData.applyFilter(f)) continue;
            UntypedEventHandler handler = e.getKey();
            list.add(new UntypedEventTask(topic, convertibleEventData, handler));
        }
        return list;
    }

    private static void checkTopicSyntax(String topic) {
        String msg = TypedEventBusImpl.checkTopicSyntax(topic, false);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static String checkTopicSyntax(String topic, boolean wildcardPermitted) {
        if (topic == null) {
            throw new IllegalArgumentException("The topic name is not permitted to be null");
        }
        boolean slashPermitted = false;
        for (int i = 0; i < topic.length(); ++i) {
            int c = topic.codePointAt(i);
            if (42 == c) {
                if (!wildcardPermitted) {
                    return "Wildcard topics may not be used for sending events";
                }
                if (topic.length() != i + 1) {
                    return "The wildcard * is only permitted at the end of the topic";
                }
                if (topic.length() <= 1 || topic.codePointAt(i - 1) == 47) continue;
                return "The wildcard must be preceded by a / unless it is the only character in the topic string";
            }
            if (47 == c) {
                if (slashPermitted && i != topic.length() - 1) {
                    slashPermitted = false;
                    continue;
                }
            } else if (45 == c || Character.isJavaIdentifierPart(c)) {
                slashPermitted = true;
                continue;
            }
            return "Illegal character " + c + " at index " + i + " of topic string: " + topic;
        }
        return null;
    }

    private static boolean isWildcard(String topic) {
        return topic.equals("*") || topic.endsWith("/*");
    }

    private class EventThread
    extends Thread {
        private final AtomicBoolean running;

        public EventThread() {
            super("Apache Aries TypedEventBus Delivery Thread");
            this.running = new AtomicBoolean(true);
        }

        public void shutdown() {
            this.running.set(false);
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.running.get()) {
                EventTask take;
                try {
                    take = (EventTask)TypedEventBusImpl.this.queue.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                take.notifyListener();
            }
        }
    }
}

