/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.sensinact.gateway.launcher.ConfigurationManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.feature.Feature;
import org.osgi.service.feature.FeatureArtifact;
import org.osgi.service.feature.FeatureBundle;
import org.osgi.service.feature.FeatureConfiguration;
import org.osgi.service.feature.FeatureExtension;
import org.osgi.service.feature.FeatureService;
import org.osgi.service.feature.ID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"sensinact.launcher"})
public class FeatureLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureLauncher.class);
    private static final String SENSINACT_FEATURE_DEPENDENCY = "sensinact.feature.depends";
    private final Pattern variablePattern = Pattern.compile("\\$\\{([^\\{\\}\\$]+)\\}");
    @Reference
    FeatureService featureService;
    @Reference
    ConfigurationManager configManager;
    private BundleContext context;
    private FeatureExtension noDependencies;
    private final Map<String, Bundle> bundlesByIdentifier = new HashMap<String, Bundle>();
    private final Map<String, List<String>> featuresToBundles = new HashMap<String, List<String>>();
    private final Map<String, Collection<String>> featuresConfigurations = new HashMap<String, Collection<String>>();
    private final List<String> features = new ArrayList<String>();
    private List<Path> repositories;
    private List<Path> featureDirs;

    @Activate
    void start(BundleContext context, Config config) throws ConfigurationException {
        this.context = context;
        this.noDependencies = this.featureService.getBuilderFactory().newExtensionBuilder(SENSINACT_FEATURE_DEPENDENCY, FeatureExtension.Type.ARTIFACTS, FeatureExtension.Kind.MANDATORY).build();
        this.update(config);
    }

    Path getPath(String initialPath) {
        String newPath = Paths.get(initialPath, new String[0]).normalize().toString();
        Pattern envVarsPattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        Matcher matcher = envVarsPattern.matcher(newPath);
        while (matcher.find()) {
            String innerVar = matcher.group(1);
            String resolvedEnv = System.getenv(innerVar);
            if (resolvedEnv == null) continue;
            newPath = newPath.replace(matcher.group(), resolvedEnv);
        }
        newPath = Paths.get(newPath.replaceFirst("^~(" + Pattern.quote(File.separator) + "|/)", Matcher.quoteReplacement(System.getProperty("user.home") + File.separator)), new String[0]).normalize().toString();
        return Paths.get(newPath, new String[0]).normalize();
    }

    List<Path> getPaths(String[] paths) {
        if (paths == null || paths.length == 0) {
            return List.of();
        }
        if (paths.length == 1) {
            if (paths[0].contains(";")) {
                paths = paths[0].split("(?<!\\\\);");
            } else if (paths[0].contains(":")) {
                paths = paths[0].split("(?<!\\\\):");
            }
        }
        return Arrays.stream(paths).map(p -> this.getPath((String)p)).collect(Collectors.toList());
    }

    @Modified
    void update(Config config) throws ConfigurationException {
        this.repositories = this.getPaths(config.repository());
        this.featureDirs = this.getPaths(config.featureDir());
        List newFeatures = Arrays.stream(config.features()).collect(Collectors.toList());
        LOGGER.info("Feature installation for features {} requested using repositories {} and feature directories {}", new Object[]{newFeatures, this.repositories, this.featureDirs});
        List<String> removed = this.features.stream().filter(s -> !newFeatures.contains(s)).collect(Collectors.toList());
        if (!removed.isEmpty()) {
            LOGGER.info("The following features {} are no longer required and will be removed.", removed);
        }
        this.removeFeatures(removed);
        try {
            this.removeFeaturesConfigurations(removed);
        }
        catch (IOException e) {
            LOGGER.error("Error removing configurations of features: {}", removed, (Object)e);
        }
        ArrayList<String> installProgress = new ArrayList<String>(newFeatures.size());
        for (String newFeature : newFeatures) {
            this.addOrUpdate(newFeature, installProgress);
            installProgress.add(newFeature);
        }
        this.features.clear();
        this.features.addAll(newFeatures);
        LOGGER.info("Feature update complete.");
    }

    @Deactivate
    void stop() {
        this.removeFeatures(this.features);
        this.features.clear();
    }

    private void removeFeatures(List<String> removed) {
        Bundle b;
        LinkedHashSet bundles = new LinkedHashSet();
        for (String feature : removed) {
            bundles.addAll(this.featuresToBundles.remove(feature));
        }
        LinkedList<String> orderedBundlesForRemoval = new LinkedList<String>();
        for (String bundle : bundles) {
            if (!this.featuresToBundles.values().stream().noneMatch(c -> c.contains(bundle))) continue;
            orderedBundlesForRemoval.addFirst(bundle);
        }
        LOGGER.debug("The following bundles {} are no longer required and will be removed.", orderedBundlesForRemoval);
        for (String s : orderedBundlesForRemoval) {
            b = this.bundlesByIdentifier.get(s);
            if (b == null) continue;
            try {
                BundleRevision rev = (BundleRevision)b.adapt(BundleRevision.class);
                if (rev == null || (rev.getTypes() & 1) != 0) continue;
                b.stop();
            }
            catch (BundleException e) {
                LOGGER.warn("An error occurred stopping bundle {}.", (Object)s, (Object)e);
            }
        }
        for (String s : orderedBundlesForRemoval) {
            b = this.bundlesByIdentifier.remove(s);
            if (b == null) continue;
            try {
                b.uninstall();
            }
            catch (BundleException e) {
                LOGGER.warn("An error occurred uninstalling bundle {}.", (Object)s, (Object)e);
            }
        }
    }

    private void addOrUpdate(String feature, List<String> installProgress) throws ConfigurationException {
        Feature featureModel = this.loadFeature(feature);
        this.validateFeatureModel(feature, featureModel, installProgress);
        Map<String, Hashtable<String, Object>> featureConfs = this.loadFeatureConfigurations(featureModel);
        Collection removedConfs = this.featuresConfigurations.remove(feature);
        if (removedConfs != null) {
            removedConfs = removedConfs.stream().filter(pid -> !featureConfs.containsKey(pid)).collect(Collectors.toList());
        }
        this.featuresConfigurations.put(feature, featureConfs.keySet());
        if (!featureConfs.isEmpty() || removedConfs != null && !removedConfs.isEmpty()) {
            try {
                this.configManager.updateConfigurations(featureConfs, removedConfs);
            }
            catch (IOException e) {
                LOGGER.error("Error updating configuration for feature {}", (Object)feature, (Object)e);
            }
        }
        List bundles = featureModel.getBundles().stream().map(fb -> fb.getID().toString()).collect(Collectors.toList());
        if (this.featuresToBundles.containsKey(feature)) {
            LOGGER.debug("Updating feature {}", (Object)feature);
            if (this.featuresToBundles.get(feature).equals(bundles)) {
                LOGGER.debug("The feature {} is already up to date", (Object)feature);
                return;
            }
            LOGGER.debug("The feature {} is out of date and will be removed and re-installed", (Object)feature);
            this.removeFeatures(List.of(feature));
        }
        this.featuresToBundles.put(feature, bundles);
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (FeatureBundle fb2 : featureModel.getBundles()) {
            Bundle bundle;
            ID bundleIdentifier = fb2.getID();
            String bid = bundleIdentifier.toString();
            if (this.bundlesByIdentifier.containsKey(bid) || (bundle = this.installBundle(bundleIdentifier)) == null) continue;
            this.bundlesByIdentifier.put(bid, bundle);
            installed.add(bundle);
        }
        for (Bundle b : installed) {
            try {
                BundleRevision rev = (BundleRevision)b.adapt(BundleRevision.class);
                if (rev != null && (rev.getTypes() & 1) == 0) {
                    b.start();
                    continue;
                }
                LOGGER.debug("Not starting bundle {} as it is a fragment", (Object)b.getSymbolicName());
            }
            catch (Exception e) {
                LOGGER.warn("An error occurred starting a bundle in feature {}", (Object)feature, (Object)e);
            }
        }
    }

    private Feature loadFeature(String feature) {
        LOGGER.debug("Loading feature model {}", (Object)feature);
        Path featureFile = null;
        if (feature.indexOf(58) >= 0) {
            try {
                featureFile = this.getFileFromRepository(this.featureService.getIDfromMavenCoordinates(feature), "json");
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Can't find feature file: {}", (Object)feature, (Object)e);
            }
        } else {
            Object simpleFileName = feature;
            if (!((String)simpleFileName).endsWith(".json")) {
                simpleFileName = (String)simpleFileName + ".json";
            }
            for (Path featureDir : this.featureDirs) {
                Path testedFile = featureDir.resolve((String)simpleFileName);
                if (!Files.isRegularFile(testedFile, new LinkOption[0])) continue;
                featureFile = testedFile;
                break;
            }
        }
        if (featureFile != null && Files.isRegularFile(featureFile, new LinkOption[0])) {
            Feature feature2;
            block16: {
                BufferedReader fr = Files.newBufferedReader(featureFile, StandardCharsets.UTF_8);
                try {
                    feature2 = this.featureService.readFeature((Reader)fr);
                    if (fr == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (fr != null) {
                            try {
                                ((Reader)fr).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        LOGGER.error("Failed to parse feature {} from file {}", new Object[]{feature, featureFile, ioe});
                    }
                }
                ((Reader)fr).close();
            }
            return feature2;
        } else {
            LOGGER.error("No feature file for feature {}", (Object)feature);
        }
        return null;
    }

    private void validateFeatureModel(String feature, Feature featureModel, List<String> installProgress) throws ConfigurationException {
        if (featureModel == null) {
            LOGGER.error("Unable to locate a valid feature " + feature);
            throw new ConfigurationException("features", "The feature " + feature + " cannot be deployed as it cannot be found.");
        }
        FeatureExtension dependencies = featureModel.getExtensions().getOrDefault(SENSINACT_FEATURE_DEPENDENCY, this.noDependencies);
        if (dependencies.getType() != FeatureExtension.Type.ARTIFACTS) {
            LOGGER.error("The feature {} includes a sensinact.feature.depends extension of the wrong type {}", (Object)feature, (Object)dependencies.getType());
            throw new ConfigurationException("features", "The feature " + feature + "contains a sensinact.feature.depends extension of the wrong type.");
        }
        ArrayList<ID> unsatisfied = new ArrayList<ID>();
        for (FeatureArtifact featureArtifact : dependencies.getArtifacts()) {
            ID id = featureArtifact.getID();
            if (installProgress.contains(id.getArtifactId())) {
                LOGGER.debug("The feature {} depends on the feature {}, which is installed", (Object)feature, (Object)id.getArtifactId());
                continue;
            }
            if (installProgress.contains(id.toString())) {
                LOGGER.debug("The feature {} depends on the feature {}, which is installed", (Object)feature, (Object)id.toString());
                continue;
            }
            LOGGER.error("The feature {} depends on the feature {} which is not installed before it", (Object)feature, (Object)id.toString());
            unsatisfied.add(id);
        }
        if (!unsatisfied.isEmpty()) {
            throw new ConfigurationException("features", "The feature " + feature + "contains a sensinact.feature.depends extension which is not satisfied. The unsatisfied dependencies are" + ((Object)unsatisfied).toString());
        }
        List unknownMandatory = featureModel.getExtensions().entrySet().stream().filter(e -> ((FeatureExtension)e.getValue()).getKind() == FeatureExtension.Kind.MANDATORY).map(Map.Entry::getKey).filter(s -> !SENSINACT_FEATURE_DEPENDENCY.equals(s)).collect(Collectors.toList());
        if (!unknownMandatory.isEmpty()) {
            LOGGER.error("The feature {} has mandatory extensions {} which are not understood by sensiNact");
            throw new ConfigurationException("features", "The feature " + feature + "contains mandatory extension(s) " + ((Object)unsatisfied).toString() + " which are not understood.");
        }
    }

    private Bundle installBundle(ID bundleIdentifier) {
        Bundle bundle;
        block8: {
            LOGGER.debug("Installing bundle {}", (Object)bundleIdentifier.toString());
            InputStream is = Files.newInputStream(this.getFileFromRepository(bundleIdentifier, "jar"), new OpenOption[0]);
            try {
                bundle = this.context.installBundle(bundleIdentifier.toString(), is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("An error occurred installing bundle {}", (Object)bundleIdentifier.toString(), (Object)e);
                    return null;
                }
            }
            is.close();
        }
        return bundle;
    }

    private Path getFileFromRepository(ID id, String defaultType) throws FileNotFoundException {
        LOGGER.debug("Searching for feature {} in repositories {}", (Object)id, this.repositories);
        String groupPath = id.getGroupId().replace('.', File.separatorChar);
        Path path = null;
        for (Path repository : this.repositories) {
            Path testedPath = repository.resolve(groupPath).resolve(id.getArtifactId()).resolve(id.getVersion());
            if (!Files.isDirectory(testedPath, new LinkOption[0])) continue;
            path = testedPath;
            break;
        }
        if (path == null) {
            throw new FileNotFoundException("Can't find feature " + id);
        }
        Path repoPath = path;
        String fileName = id.getClassifier().isEmpty() ? String.format("%s-%s", id.getArtifactId(), id.getVersion()) : String.format("%s-%s-%s", id.getArtifactId(), id.getVersion(), id.getClassifier().get());
        fileName = fileName.concat(String.format(".%s", id.getType().orElse(defaultType)));
        Path file = repoPath.resolve(fileName);
        LOGGER.debug("Expected file path for feature {} is {}", (Object)id, (Object)file);
        if (!Files.isRegularFile(file, new LinkOption[0]) && id.getVersion().endsWith("-SNAPSHOT")) {
            LOGGER.debug("File not found, looking for the latest SNAPSHOT");
            String regex = id.getClassifier().isEmpty() ? String.format("%s-%s-\\d{8}\\.\\d{6}-\\d+\\.%s", id.getArtifactId(), id.getVersion().substring(0, id.getVersion().length() - "-SNAPSHOT".length()), id.getType().orElse(defaultType)) : String.format("%s-%s-\\d{8}\\.\\d{6}-\\d+-%s\\.%s", id.getArtifactId(), id.getVersion().substring(0, id.getVersion().length() - "-SNAPSHOT".length()), id.getClassifier().get(), id.getType().orElse(defaultType));
            Pattern pattern = Pattern.compile(regex);
            LOGGER.debug("File not found, looking for the latest SNAPSHOT");
            try {
                Optional<Path> found = Files.list(repoPath).map(p -> p.getFileName().toString()).filter(pattern.asMatchPredicate()).sorted(Comparator.reverseOrder()).findFirst().map(s -> repoPath.resolve((String)s));
                if (found.isPresent()) {
                    file = found.get();
                    LOGGER.debug("A SNAPSHOT file was found for feature {} at {}", (Object)id, (Object)file);
                }
            }
            catch (IOException e) {
                LOGGER.warn("An error occurred while searching for snapshot files", (Throwable)e);
            }
        }
        return file;
    }

    private void removeFeaturesConfigurations(Collection<String> removedFeatures) throws IOException {
        Set<String> removedPids = removedFeatures.stream().map(this.featuresConfigurations::remove).filter(Objects::nonNull).flatMap(pids -> pids.stream()).collect(Collectors.toSet());
        if (!removedPids.isEmpty()) {
            this.configManager.updateConfigurations(null, removedPids);
        }
    }

    private Map<String, Hashtable<String, Object>> loadFeatureConfigurations(Feature feature) {
        Map variables = feature.getVariables();
        HashMap<String, Hashtable<String, Object>> result = new HashMap<String, Hashtable<String, Object>>();
        for (Map.Entry entry : feature.getConfigurations().entrySet()) {
            Hashtable<String, Object> values = new Hashtable<String, Object>(((FeatureConfiguration)entry.getValue()).getValues());
            this.fillInVariables(values, (Map<String, Object>)variables);
            result.put((String)entry.getKey(), values);
        }
        return result;
    }

    void fillInVariables(Map<String, Object> config, Map<String, Object> vars) {
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            Object rawValue = entry.getValue();
            if (!(rawValue instanceof String)) continue;
            entry.setValue(this.fillInVariables((String)rawValue, vars));
        }
    }

    private Object fillInVariables(String value, Map<String, Object> vars) {
        Matcher matcher = this.variablePattern.matcher(value);
        String newValue = value;
        while (matcher.find()) {
            if (matcher.start() == 0 && matcher.end() == value.length()) {
                return vars.getOrDefault(matcher.group(1), matcher.group());
            }
            newValue = newValue.replace(matcher.group(), String.valueOf(vars.getOrDefault(matcher.group(1), matcher.group())));
        }
        return newValue;
    }

    static @interface Config {
        public String[] features() default {};

        public String[] repository() default {"repository"};

        public String[] featureDir() default {"features"};
    }
}

