/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application.persistence;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.eclipse.sensinact.gateway.app.api.persistence.dao.Application;
import org.eclipse.sensinact.gateway.app.manager.application.persistence.exception.ApplicationParseException;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileToApplicationParser {
    public static Application parse(String filepath) throws ApplicationParseException {
        try {
            File file = new File(filepath);
            List<String> lines = Files.readAllLines(file.toPath(), Charset.defaultCharset());
            StringBuffer sb = new StringBuffer();
            for (String line : lines) {
                sb.append(line);
            }
            String content = sb.toString();
            JSONObject jsonFileContent = new JSONObject(content);
            JSONArray array = jsonFileContent.getJSONArray("parameters");
            String applicationName = array.getJSONObject(0).getString("value");
            JSONObject jsonApplicationContent = array.getJSONObject(1).getJSONObject("value");
            String filename = file.getName();
            Integer indexOfLastDot = filename.lastIndexOf(46);
            String filenameNoExtention = null;
            filenameNoExtention = indexOfLastDot != -1 ? filename.substring(0, indexOfLastDot) : filename;
            if (!applicationName.equals(filenameNoExtention)) {
                throw new ApplicationParseException("The file name and the application name should be the same");
            }
            String diggest = new String(MessageDigest.getInstance("MD5").digest(content.getBytes()));
            Application application = new Application(applicationName, diggest, jsonFileContent);
            return application;
        }
        catch (IOException e) {
            throw new ApplicationParseException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApplicationParseException(e);
        }
    }
}

