/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.factory;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.api.exception.ApplicationFactoryException;
import org.eclipse.sensinact.gateway.app.api.exception.FunctionNotFoundException;
import org.eclipse.sensinact.gateway.app.api.function.AbstractFunction;
import org.eclipse.sensinact.gateway.app.manager.application.Application;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.app.manager.application.ResourceSubscription;
import org.eclipse.sensinact.gateway.app.manager.component.AbstractDataProvider;
import org.eclipse.sensinact.gateway.app.manager.component.Component;
import org.eclipse.sensinact.gateway.app.manager.component.DataProvider;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderItf;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderSubscription;
import org.eclipse.sensinact.gateway.app.manager.component.ResourceDataProvider;
import org.eclipse.sensinact.gateway.app.manager.component.property.RegisterPropertyBlock;
import org.eclipse.sensinact.gateway.app.manager.factory.ComponentBuilder;
import org.eclipse.sensinact.gateway.app.manager.json.AppComponent;
import org.eclipse.sensinact.gateway.app.manager.json.AppContainer;
import org.eclipse.sensinact.gateway.app.manager.json.AppEvent;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.osgi.PluginsProxy;
import org.eclipse.sensinact.gateway.app.manager.watchdog.AppExceptionWatchDog;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.SensorDataResource;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationFactory.class);

    /*
     * WARNING - void declaration
     */
    public static Application createApplication(AppServiceMediator mediator, AppContainer container, ServiceImpl service) throws ApplicationFactoryException {
        String resultUri;
        String componentUri;
        String applicationUri = "/" + container.getApplicationName();
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        HashMap<String, AbstractDataProvider> allDataProvidersMap = new HashMap<String, AbstractDataProvider>();
        HashMap<ResourceDataProvider, Collection<ResourceSubscription>> resourceSubscriptions = new HashMap<ResourceDataProvider, Collection<ResourceSubscription>>();
        HashMap<String, ComponentBuilder> componentBuilderMap = new HashMap<String, ComponentBuilder>();
        ArrayList<ServiceRegistration<DataProviderItf>> dataProvidersRegistration = new ArrayList<ServiceRegistration<DataProviderItf>>();
        block8: for (AppComponent component : container.getComponents()) {
            void var14_16;
            Type superClass;
            AbstractFunction<?> function;
            componentUri = applicationUri + "/" + component.getIdentifier();
            resultUri = componentUri + "/" + "result";
            try {
                function = PluginsProxy.getFunction(mediator, component.getFunction());
            }
            catch (FunctionNotFoundException functionNotFoundException) {
                ApplicationFactoryException exception = new ApplicationFactoryException("Unable to create application " + container.getApplicationName() + ". " + functionNotFoundException.getMessage());
                if (LOG.isErrorEnabled()) {
                    LOG.error("Unable to create application " + container.getApplicationName() + ". " + functionNotFoundException.getMessage(), (Throwable)exception);
                }
                throw exception;
            }
            Class<?> clazz = function.getClass();
            ParameterizedType superType = null;
            while (superType == null && (superClass = var14_16.getGenericSuperclass()) != null) {
                try {
                    superType = (ParameterizedType)superClass;
                }
                catch (ClassCastException e) {
                    Class clazz2 = var14_16.getSuperclass();
                }
            }
            if (superType == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Instance creation error", (Throwable)new RuntimeException("Unable to instantiate: " + function.getClass()));
                }
                return null;
            }
            Type argumentType = superType.getActualTypeArguments()[0];
            if (ParameterizedType.class.isAssignableFrom(argumentType.getClass())) {
                argumentType = ((ParameterizedType)argumentType).getRawType();
            }
            nodeMap.put(resultUri, new Node(resultUri, function.isAsynchronous()));
            DataProvider resultData = new DataProvider(resultUri, (Class)argumentType);
            Hashtable<String, String> resultProperties = new Hashtable<String, String>();
            ((Dictionary)resultProperties).put("application", container.getApplicationName());
            ((Dictionary)resultProperties).put("type", ((Class)argumentType).getCanonicalName());
            ((Dictionary)resultProperties).put("uri", resultUri);
            dataProvidersRegistration.add(mediator.registerService(DataProviderItf.class, resultData, resultProperties));
            HashMap<String, DataProvider> componentDataProviderMap = new HashMap<String, DataProvider>();
            componentDataProviderMap.put("result", resultData);
            allDataProvidersMap.put(resultUri, resultData);
            ComponentBuilder builder = new ComponentBuilder(mediator, component.getIdentifier(), function, component.getFunction().getRunParameters(), componentDataProviderMap);
            componentBuilderMap.put(componentUri, builder);
            for (AppEvent event : component.getEvents()) {
                if (!event.getType().equals((Object)AppEvent.EventType.RESOURCE)) continue;
                String resourceUri = event.getUri();
                ResourceDataProvider dataProvider = new ResourceDataProvider(resourceUri);
                allDataProvidersMap.put(resourceUri, dataProvider);
                Hashtable<String, String> dataProviderProperties = new Hashtable<String, String>();
                ((Dictionary)dataProviderProperties).put("application", container.getApplicationName());
                ((Dictionary)dataProviderProperties).put("uri", resourceUri);
                dataProvidersRegistration.add(mediator.registerService(DataProviderItf.class, dataProvider, dataProviderProperties));
                if (!resourceSubscriptions.containsKey(dataProvider)) {
                    HashSet<ResourceSubscription> resourceSubscriptionsSet = new HashSet<ResourceSubscription>();
                    resourceSubscriptionsSet.add(new ResourceSubscription(resourceUri, event.getConditions()));
                    resourceSubscriptions.put(dataProvider, resourceSubscriptionsSet);
                } else {
                    boolean constraintExist = false;
                    for (ResourceSubscription resourceSubscription : (Collection)resourceSubscriptions.get(dataProvider)) {
                        if (event.getConditions().isEmpty() && resourceSubscription.getConditions().isEmpty()) {
                            constraintExist = true;
                            break;
                        }
                        if (!event.getConditions().containsAll(resourceSubscription.getConditions()) || !resourceSubscription.getConditions().containsAll(event.getConditions())) continue;
                        constraintExist = true;
                        break;
                    }
                    if (constraintExist) continue block8;
                    ((Collection)resourceSubscriptions.get(dataProvider)).add(new ResourceSubscription(resourceUri, event.getConditions()));
                }
                nodeMap.put(resourceUri, new Node(resourceUri, true));
            }
        }
        for (AppComponent component : container.getComponents()) {
            componentUri = applicationUri + "/" + component.getIdentifier();
            resultUri = componentUri + "/" + "result";
            for (AppEvent appEvent : component.getEvents()) {
                ((Node)nodeMap.get(resultUri)).addNode((Node)nodeMap.get(appEvent.getUri()));
            }
        }
        for (AppComponent component : container.getComponents()) {
            componentUri = applicationUri + "/" + component.getIdentifier();
            resultUri = componentUri + "/" + "result";
            ComponentBuilder builder = (ComponentBuilder)componentBuilderMap.get(componentUri);
            for (AppEvent event : component.getEvents()) {
                String providerUri = event.getUri();
                List<List<String>> routes = ((Node)nodeMap.get(resultUri)).getRoutes();
                builder.addEvent(providerUri, new DataProviderSubscription(providerUri, event.getConditions(), routes));
            }
        }
        for (AppComponent component : container.getComponents()) {
            componentUri = "/" + container.getApplicationName() + "/" + component.getIdentifier();
            ComponentBuilder builder = (ComponentBuilder)componentBuilderMap.get(componentUri);
            if (!component.getProperties().getRegister()) continue;
            try {
                AbstractDataProvider dataProvider = (AbstractDataProvider)allDataProvidersMap.get(componentUri + "/" + "result");
                RegisterPropertyBlock registerPropertyBlock = new RegisterPropertyBlock(service.addDataResource(SensorDataResource.class, componentUri, dataProvider.getDataType(), null), dataProvider);
                builder.addProperty("register", registerPropertyBlock);
            }
            catch (InvalidResourceException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        for (Map.Entry map : componentBuilderMap.entrySet()) {
            try {
                components.put((String)map.getKey(), ((ComponentBuilder)map.getValue()).build());
            }
            catch (ApplicationFactoryException exception) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Unable to create the component", (Throwable)exception);
                }
                throw exception;
            }
        }
        return new Application(mediator, container, container.getApplicationName(), dataProvidersRegistration, resourceSubscriptions, components, new AppExceptionWatchDog(mediator, (ApplicationService)service));
    }

    private static class Node {
        private final String uri;
        private final boolean isAsynchronous;
        private final List<Node> providerNodes;

        Node(String uri, boolean isAsynchronous) {
            this.uri = uri;
            this.isAsynchronous = isAsynchronous;
            this.providerNodes = new ArrayList<Node>();
        }

        void addNode(Node providerNode) {
            this.providerNodes.add(providerNode);
        }

        List<List<String>> getRoutes() {
            if (this.isAsynchronous || this.providerNodes.size() == 0) {
                return new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add(uri);
                            }
                        });
                    }
                };
            }
            ArrayList<List<String>> routesList = new ArrayList<List<String>>();
            for (Node node : this.providerNodes) {
                if (node == null) continue;
                List<List<String>> routes = node.getRoutes();
                for (List<String> route : routes) {
                    route.add(this.uri);
                    routesList.add(new ArrayList<String>(route));
                }
            }
            return routesList;
        }
    }
}

