/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.lang.reflect.Method;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.generic.InvalidTaskCallBackException;
import org.eclipse.sensinact.gateway.generic.Task;

public class TaskCallBack {
    private final Executable<Task, Void> executor;

    public TaskCallBack(final Method method, final Object object) throws InvalidTaskCallBackException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1 || !Task.class.isAssignableFrom(parameterTypes[0]) || !method.getDeclaringClass().isAssignableFrom(object.getClass())) {
            throw new InvalidTaskCallBackException();
        }
        this.executor = new Executable<Task, Void>(){

            public Void execute(Task task) throws Exception {
                method.setAccessible(true);
                method.invoke(object, task);
                return null;
            }
        };
    }

    public TaskCallBack(Executable<Task, Void> executor) {
        this.executor = executor;
    }

    public void callback(Task task) {
        try {
            this.executor.execute((Object)task);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

