/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.ResolvedNameTypeValueDefinition;
import org.eclipse.sensinact.gateway.generic.parser.TypeValuePair;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.xml.sax.Attributes;

@XmlAttributes(value={@XmlAttribute(attribute="target", field="target")})
public abstract class TargetedResolvedNameTypeValueDefinition
extends ResolvedNameTypeValueDefinition {
    protected String[] target;

    TargetedResolvedNameTypeValueDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    public void setTarget(String target) {
        String[] targets = target == null ? new String[]{} : target.split(",");
        this.target = new String[targets.length];
        if (this.target.length > 0) {
            for (int index = 0; index < this.target.length; ++index) {
                this.target[index] = "ANY_TARGET".equals(targets[index]) ? "#ANY_TARGET#" : targets[index];
            }
        }
    }

    public String getTarget() {
        int length;
        StringBuilder builder = new StringBuilder();
        int n = length = this.target == null ? 0 : this.target.length;
        for (int index = 0; index < length; ++index) {
            if (index > 0) {
                builder.append(",");
            }
            builder.append(this.target[0].trim());
        }
        return builder.toString();
    }

    public String[] getTargets() {
        return this.target;
    }

    public boolean isTargeted(String serviceId) {
        for (int index = 0; index < this.target.length; ++index) {
            if (!this.target[index].equals("#ANY_TARGET#") && !this.target[index].equals(serviceId)) continue;
            return true;
        }
        return false;
    }

    protected TypeValuePair getTypeValuePair(String service) {
        if (!this.isTargeted(service)) {
            return null;
        }
        return new TypeValuePair((Class)this.getType(), this.valueDefinition != null ? this.valueDefinition.getValue() : null);
    }
}

