/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfigBuilder;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.security.AccessLevel;
import org.eclipse.sensinact.gateway.core.security.AccessNodeImpl;
import org.eclipse.sensinact.gateway.core.security.AccessProfileOption;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.AccessTreeImpl;
import org.eclipse.sensinact.gateway.core.security.SecuredAccess;
import org.eclipse.sensinact.gateway.security.signature.api.BundleValidation;
import org.eclipse.sensinact.gateway.util.ReflectUtils;

public class ModelConfigurationBuilder<C extends ModelConfiguration, I extends ModelInstance<C>> {
    protected Mediator mediator;
    protected Class<C> modelConfigurationType;
    protected Class<I> modelInstanceType;
    protected Class<? extends ResourceImpl> resourceType;
    protected Class<? extends ServiceProviderImpl> serviceProviderType;
    protected Class<? extends ServiceImpl> serviceType;
    private Class<? extends Resource> defaultResourceType;
    private Class<?> defaultDataType;
    private Modifiable defaultModifiable;
    private Resource.UpdatePolicy defaultUpdatePolicy;
    protected boolean startAtInitializationTime = false;
    protected byte resourceBuildPolicy = (byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_APPEARING_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy());
    protected byte serviceBuildPolicy = (byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_APPEARING_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy());
    protected Map<String, AccessLevel> users;
    protected ResourceConfigBuilder defaultResourceConfigBuilder;
    protected ArrayList<String> observed;

    public ModelConfigurationBuilder(Mediator mediator, Class<C> resourceModelConfigurationType, Class<I> resourceModelInstanceType) {
        this.mediator = mediator;
        this.modelConfigurationType = resourceModelConfigurationType;
        this.modelInstanceType = resourceModelInstanceType;
        this.users = new HashMap<String, AccessLevel>();
    }

    public ModelConfigurationBuilder<C, I> withProviderImplementationType(Class<? extends ServiceProviderImpl> serviceProviderType) {
        this.serviceProviderType = serviceProviderType;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withServiceImplementationType(Class<? extends ServiceImpl> serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withUser(String userPublicKey, AccessLevel accessLevel) {
        this.users.put(userPublicKey, accessLevel);
        return this;
    }

    public ModelConfigurationBuilder<C, I> withResourceImplementationType(Class<? extends ResourceImpl> resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withDefaultResourceType(Class<? extends Resource> defaultResourceType) {
        this.defaultResourceType = defaultResourceType;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withDefaultDataType(Class<?> defaultDataType) {
        this.defaultDataType = defaultDataType;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withDefaultModifiable(Modifiable defaultModifiable) {
        this.defaultModifiable = defaultModifiable;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withDefaultUpdatePolicy(Resource.UpdatePolicy defaultUpdatePolicy) {
        this.defaultUpdatePolicy = defaultUpdatePolicy;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withServiceBuildPolicy(byte buildPolicy) {
        this.serviceBuildPolicy = buildPolicy;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withResourceBuildPolicy(byte buildPolicy) {
        this.resourceBuildPolicy = buildPolicy;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withDefaultResourceConfigBuilder(ResourceConfigBuilder defaultResourceConfigBuilder) {
        this.defaultResourceConfigBuilder = defaultResourceConfigBuilder;
        return this;
    }

    public ModelConfigurationBuilder withStartAtInitializationTime(boolean startAtInitializationTime) {
        this.startAtInitializationTime = startAtInitializationTime;
        return this;
    }

    public ModelConfigurationBuilder<C, I> withObserved(String observed) {
        if (this.observed == null) {
            this.observed = new ArrayList();
        }
        this.observed.add(observed);
        return this;
    }

    public ModelConfigurationBuilder<C, I> withObserved(Collection<String> observed) {
        if (this.observed == null) {
            this.observed = new ArrayList();
        }
        this.observed.addAll(observed);
        return this;
    }

    protected void configure(C configuration) {
        if (configuration == null) {
            return;
        }
        ((ModelConfiguration)configuration).setServiceBuildPolicy(this.serviceBuildPolicy).setResourceBuildPolicy(this.resourceBuildPolicy).setStartAtInitializationTime(this.startAtInitializationTime);
        if (this.resourceType != null) {
            ((ModelConfiguration)configuration).setResourceImplementationType((Class)this.resourceType);
        }
        if (this.serviceType != null) {
            ((ModelConfiguration)configuration).setServiceImplmentationType((Class)this.serviceType);
        }
        if (this.serviceProviderType != null) {
            ((ModelConfiguration)configuration).setProviderImplementationType((Class)this.serviceProviderType);
        }
        if (this.defaultResourceType != null) {
            ((ModelConfiguration)configuration).setDefaultResourceType((Class)this.defaultResourceType);
        }
        if (this.defaultDataType != null) {
            ((ModelConfiguration)configuration).setDefaultDataType((Class)this.defaultDataType);
        }
        if (this.defaultModifiable != null) {
            ((ModelConfiguration)configuration).setDefaultModifiable(this.defaultModifiable);
        }
        if (this.defaultUpdatePolicy != null) {
            ((ModelConfiguration)configuration).setDefaultUpdatePolicy(this.defaultUpdatePolicy);
        }
        if (this.observed != null) {
            ((ModelConfiguration)configuration).setObserved(this.observed);
        }
        if (this.modelInstanceType != null) {
            ((ModelConfiguration)configuration).setModelInstanceType(this.modelInstanceType);
        }
    }

    protected AccessTree<?> buildAccessTree() {
        return (AccessTree)AccessController.doPrivileged(new PrivilegedAction<AccessTree<?>>(){

            @Override
            public AccessTree<?> run() {
                final String identifier = (String)ModelConfigurationBuilder.this.mediator.callService(BundleValidation.class, (Executable)new Executable<BundleValidation, String>(){

                    public String execute(BundleValidation service) throws Exception {
                        return service.check(ModelConfigurationBuilder.this.mediator.getContext().getBundle());
                    }
                });
                AccessTree<AccessNodeImpl<Object>> tree = null;
                tree = identifier == null ? new AccessTreeImpl().withAccessProfile(AccessProfileOption.ALL_ANONYMOUS) : (AccessTree)ModelConfigurationBuilder.this.mediator.callService(SecuredAccess.class, new Executable<SecuredAccess, AccessTree<?>>(){

                    public AccessTree<?> execute(SecuredAccess service) throws Exception {
                        return service.getAccessTree(identifier);
                    }
                });
                return tree;
            }
        });
    }

    public C build(Object ... parameters) {
        ModelConfiguration configuration = null;
        AccessTree<?> accessTree = this.buildAccessTree();
        int parametersLength = parameters == null ? 0 : parameters.length;
        int offset = this.defaultResourceConfigBuilder != null ? 3 : 2;
        Object[] arguments = new Object[parametersLength + offset];
        if (parametersLength > 0) {
            System.arraycopy(parameters, 0, arguments, offset, parametersLength);
        }
        arguments[0] = this.mediator;
        arguments[1] = accessTree;
        if (this.defaultResourceConfigBuilder != null) {
            arguments[2] = this.defaultResourceConfigBuilder;
        }
        configuration = (ModelConfiguration)ReflectUtils.getInstance(ModelConfiguration.class, this.modelConfigurationType, (Object[])arguments);
        this.configure(configuration);
        return (C)configuration;
    }
}

