/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.filtering.Filtering;
import org.eclipse.sensinact.gateway.core.filtering.FilteringDefinition;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.Argument;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestBuilder;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestHandler;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNorthboundRequestHandler
implements NorthboundRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNorthboundRequestHandler.class);
    public static String RAW_QUERY_PARAMETER = "#RAW#";
    protected NorthboundMediator mediator = null;
    private String serviceProvider = null;
    private String service = null;
    private String resource = null;
    private String attribute = null;
    private boolean isElementsList = false;
    private boolean multi = false;
    protected String rid;
    protected String method = null;
    private Map<NorthboundRequestWrapper.QueryKey, List<String>> query;
    private NorthboundRequestWrapper request;
    private NorthboundRequestHandler.NorthboundResponseBuildError buildError;
    private Set<String> methods;

    @Override
    public void init(NorthboundRequestWrapper request, Set<AccessMethod.Type> methods) throws IOException {
        this.mediator = request.getMediator();
        if (this.mediator == null) {
            throw new IOException("Unable to process the request");
        }
        this.request = request;
        this.buildError = null;
        this.query = request.getQueryMap();
        this.methods = methods.stream().collect(HashSet::new, (l, r) -> l.add(r.name()), Set::addAll);
    }

    public void init(NorthboundRequestWrapper request) throws IOException {
        this.init(request, new HashSet<AccessMethod.Type>(Arrays.asList(AccessMethod.Type.values())));
    }

    @Override
    public NorthboundRequestHandler.NorthboundResponseBuildError getBuildError() {
        return this.buildError;
    }

    @Override
    public boolean processRequestURI() {
        String path = null;
        String requestURI = this.request.getRequestURI();
        try {
            path = UriUtils.formatUri((String)URLDecoder.decode(requestURI, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        this.serviceProvider = null;
        this.service = null;
        this.resource = null;
        this.attribute = null;
        this.method = null;
        this.multi = false;
        String[] pathElements = UriUtils.getUriElements((String)path);
        int lastIndex = pathElements.length - 1;
        if (this.methods.contains(pathElements[pathElements.length - 1])) {
            this.method = pathElements[pathElements.length - 1];
            --lastIndex;
        }
        switch (pathElements[lastIndex]) {
            case "resources": {
                this.service = pathElements[lastIndex - 1];
                lastIndex -= 2;
            }
            case "services": {
                this.serviceProvider = pathElements[lastIndex - 1];
            }
            case "providers": {
                this.multi = true;
                this.isElementsList = true;
                break;
            }
            case "sensinact": {
                if (this.method == null) {
                    this.method = "ALL";
                }
                this.multi = true;
                break;
            }
        }
        if (!this.multi) {
            switch (pathElements[lastIndex - 1]) {
                case "resources": {
                    this.resource = pathElements[lastIndex];
                    lastIndex -= 2;
                }
                case "services": {
                    this.service = pathElements[lastIndex];
                    lastIndex -= 2;
                }
                case "providers": {
                    this.serviceProvider = pathElements[lastIndex];
                    break;
                }
                default: {
                    switch (lastIndex) {
                        case 3: {
                            this.resource = pathElements[lastIndex];
                            --lastIndex;
                        }
                        case 2: {
                            this.service = pathElements[lastIndex];
                            --lastIndex;
                        }
                        case 1: {
                            this.serviceProvider = pathElements[lastIndex];
                        }
                    }
                }
            }
        }
        this.method = this.method == null ? AccessMethod.DESCRIBE : this.method;
        return true;
    }

    private List<Parameter> processParameters() throws IOException, JSONException {
        String content = this.request.getContent();
        JSONArray parameters = null;
        if (content == null) {
            parameters = new JSONArray();
        } else {
            try {
                JSONObject jsonObject = new JSONObject(content);
                parameters = jsonObject.optJSONArray("parameters");
            }
            catch (JSONException e) {
                try {
                    parameters = new JSONArray(content);
                }
                catch (JSONException je) {
                    LOG.debug("No JSON formated content in %s", (Object)content);
                }
            }
        }
        int length = parameters == null ? 0 : parameters.length();
        ArrayList<Parameter> parametersList = new ArrayList<Parameter>();
        for (int index = 0; index < length; ++index) {
            Parameter parameter = null;
            try {
                parameter = new Parameter((Mediator)this.mediator, parameters.optJSONObject(index));
            }
            catch (InvalidValueException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                continue;
            }
            if ("attributeName".equals(parameter.getName()) && String.class == parameter.getType()) {
                this.attribute = (String)parameter.getValue();
                continue;
            }
            parametersList.add(parameter);
        }
        for (Map.Entry<NorthboundRequestWrapper.QueryKey, List<String>> entry : this.query.entrySet()) {
            Parameter parameter = null;
            try {
                parameter = new Parameter((Mediator)this.mediator, entry.getKey().name, entry.getValue().size() > 1 ? JSONArray.class : String.class, (Object)(entry.getValue().size() == 0 ? "true" : (entry.getValue().size() == 1 ? entry.getValue().get(0) : new JSONArray((Collection)entry.getValue()))));
            }
            catch (InvalidValueException e) {
                throw new JSONException((Throwable)e);
            }
            if ("attributeName".equals(parameter.getName()) && String.class == parameter.getType()) {
                this.attribute = (String)parameter.getValue();
                continue;
            }
            parametersList.add(parameter);
        }
        return parametersList;
    }

    private void processAttribute(NorthboundRequestBuilder builder) {
        if (this.attribute != null) {
            builder.withAttribute(this.attribute);
        }
    }

    private void processFilters(NorthboundRequestBuilder builder, List<Parameter> parameters) throws IOException {
        ArrayList<FilteringDefinition> defs = new ArrayList<FilteringDefinition>();
        String filter = null;
        boolean hidden = false;
        Iterator<Parameter> it = parameters.iterator();
        while (it.hasNext()) {
            Parameter parameter = it.next();
            String name = parameter.getName();
            if ("hideFilter".equals(name)) {
                hidden = (Boolean)CastUtils.castPrimitive(Boolean.TYPE, (Object)parameter.getValue());
                it.remove();
                continue;
            }
            int rank = -1;
            int ind = name.lastIndexOf(".");
            if (ind > 0) {
                try {
                    rank = Integer.parseInt(name.substring(ind + 1));
                    name = name.substring(0, ind);
                }
                catch (NumberFormatException e) {
                    rank = -1;
                }
            }
            try {
                int i;
                Collection references = this.mediator.getContext().getServiceReferences(Filtering.class, String.format("(%s=%s)", "sensinact.filtering.type", name));
                if (references == null || references.size() != 1) continue;
                filter = (String)CastUtils.castPrimitive(String.class, (Object)parameter.getValue());
                for (i = 0; i < defs.size(); ++i) {
                    if (rank > ((FilteringDefinition)defs.get((int)i)).rank) continue;
                    defs.add(i, new FilteringDefinition(name, filter, rank));
                    break;
                }
                if (i == defs.size()) {
                    defs.add(new FilteringDefinition(name, filter, rank));
                }
                it.remove();
            }
            catch (InvalidSyntaxException e) {}
        }
        if (defs.size() == 0) {
            return;
        }
        builder.withFilter(defs.size());
        AtomicInteger n = new AtomicInteger(-1);
        defs.stream().forEach(d -> builder.withFilter((FilteringDefinition)d, n.incrementAndGet()));
        builder.withHiddenFilter(hidden);
    }

    @Override
    public NorthboundRequestBuilder handle() throws IOException {
        List<Parameter> parameters;
        block3: {
            parameters = null;
            try {
                parameters = this.processParameters();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.buildError = new NorthboundRequestHandler.NorthboundResponseBuildError(500, "Error processing the request content");
                return null;
            }
            catch (JSONException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                String content = this.request.getContent();
                if (content == null || content.isEmpty()) break block3;
                this.buildError = new NorthboundRequestHandler.NorthboundResponseBuildError(400, "Invalid parameter(s) format");
                return null;
            }
        }
        return this.handle(parameters);
    }

    private NorthboundRequestBuilder handle(List<Parameter> parameters) throws IOException {
        NorthboundRequestBuilder builder = new NorthboundRequestBuilder(this.mediator);
        this.processFilters(builder, parameters);
        builder.withMethod(this.method).withServiceProvider(this.serviceProvider).withService(this.service).withResource(this.resource);
        if (!(this.multi || this.method.equals(AccessMethod.ACT) || this.method.equals(AccessMethod.DESCRIBE))) {
            this.processAttribute(builder);
        }
        this.rid = this.request.getRequestId();
        if (this.rid == null) {
            String requestIdName = this.request.getRequestIdProperty();
            Iterator<Parameter> it = parameters.iterator();
            while (it.hasNext()) {
                Parameter parameter = it.next();
                String name = parameter.getName();
                if (!name.equals(requestIdName)) continue;
                this.rid = String.valueOf(parameter.getValue());
                it.remove();
                break;
            }
        }
        builder.withRequestId(this.rid);
        switch (this.method) {
            case "DESCRIBE": {
                builder.isElementsList(this.isElementsList);
                break;
            }
            case "ACT": 
            case "GET": {
                int length = parameters.size();
                for (int index = 0; index < length; ++index) {
                    builder.withArgument(new Argument(parameters.get(index).getType(), parameters.get(index).getValue()));
                }
                break;
            }
            case "UNSUBSCRIBE": {
                if (parameters == null || parameters.isEmpty()) {
                    this.buildError = new NorthboundRequestHandler.NorthboundResponseBuildError(400, "A Parameter was expected");
                    return null;
                }
                if (parameters.get(0) == null || parameters.get(0).getType() != String.class) {
                    this.buildError = new NorthboundRequestHandler.NorthboundResponseBuildError(400, "Invalid parameter format");
                    return null;
                }
                builder.withArgument(new Argument(String.class, parameters.get(0).getValue()));
                int length = parameters.size();
                for (int index = 1; index < length; ++index) {
                    builder.withArgument(new Argument(parameters.get(index).getType(), parameters.get(index).getValue()));
                }
                break;
            }
            case "SET": {
                if (parameters == null || parameters.get(0) == null) {
                    this.buildError = new NorthboundRequestHandler.NorthboundResponseBuildError(400, "A Parameter was expected");
                    return null;
                }
                builder.withArgument(new Argument(Object.class, parameters.get(0).getValue()));
                int length = parameters.size();
                for (int index = 1; index < length; ++index) {
                    builder.withArgument(new Argument(parameters.get(index).getType(), parameters.get(index).getValue()));
                }
                break;
            }
            case "SUBSCRIBE": {
                int length;
                NorthboundRecipient recipient = this.request.createRecipient(parameters);
                if (recipient == null) {
                    this.buildError = new NorthboundRequestHandler.NorthboundResponseBuildError(400, "Unable to create the appropriate recipient");
                    return null;
                }
                String sender = null;
                boolean isPattern = false;
                boolean isComplement = false;
                String policy = String.valueOf(0x100010);
                SnaMessage.Type[] types = null;
                JSONArray conditions = null;
                ArrayList<Parameter> extraParameters = new ArrayList<Parameter>();
                int n = length = parameters == null ? 0 : parameters.size();
                while (length > 0) {
                    String name;
                    boolean found = false;
                    Parameter parameter = parameters.remove(0);
                    switch (name = parameter.getName()) {
                        case "callback": {
                            found = true;
                            break;
                        }
                        case "conditions": {
                            conditions = (JSONArray)CastUtils.cast(JSONArray.class, (Object)parameter.getValue());
                            found = true;
                            break;
                        }
                        case "sender": {
                            sender = (String)CastUtils.cast(String.class, (Object)parameter.getValue());
                            found = true;
                            break;
                        }
                        case "pattern": {
                            isPattern = (Boolean)CastUtils.cast(Boolean.TYPE, (Object)parameter.getValue());
                            found = true;
                            break;
                        }
                        case "complement": {
                            isComplement = (Boolean)CastUtils.cast(Boolean.TYPE, (Object)parameter.getValue());
                            found = true;
                            break;
                        }
                        case "types": {
                            types = (SnaMessage.Type[])CastUtils.castArray(SnaMessage.Type[].class, (Object)parameter.getValue());
                            found = true;
                        }
                        case "policy": {
                            policy = (String)CastUtils.cast(String.class, (Object)parameter.getValue());
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        extraParameters.add(parameter);
                    }
                    length = parameters.size();
                }
                if (sender == null) {
                    sender = "(/[^/]+)+";
                    isPattern = true;
                }
                if (types == null) {
                    types = SnaMessage.Type.values();
                }
                if (conditions == null) {
                    conditions = new JSONArray();
                }
                builder.withArgument(new Argument(NorthboundRecipient.class, recipient));
                if (this.resource == null) {
                    SnaFilter snaFilter = new SnaFilter((Mediator)this.mediator, sender, isPattern, isComplement, conditions);
                    snaFilter.addHandledType(types);
                    builder.withArgument(new Argument(SnaFilter.class, snaFilter));
                } else {
                    builder.withArgument(new Argument(JSONArray.class, conditions));
                    builder.withArgument(new Argument(String.class, policy));
                }
                int n2 = length = extraParameters == null ? 0 : extraParameters.size();
                for (int index = 0; index < length; ++index) {
                    builder.withArgument(new Argument(((Parameter)extraParameters.get(index)).getType(), ((Parameter)extraParameters.get(index)).getValue()));
                }
                break;
            }
        }
        return builder;
    }
}

