/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.sensinact.gateway.app.api.exception.ApplicationRuntimeException;
import org.eclipse.sensinact.gateway.app.api.exception.LifeCycleException;
import org.eclipse.sensinact.gateway.app.api.function.AbstractFunction;
import org.eclipse.sensinact.gateway.app.api.function.DataItf;
import org.eclipse.sensinact.gateway.app.api.function.FunctionUpdateListener;
import org.eclipse.sensinact.gateway.app.manager.component.DataListenerItf;
import org.eclipse.sensinact.gateway.app.manager.component.DataProvider;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderItf;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderSubscription;
import org.eclipse.sensinact.gateway.app.manager.component.Event;
import org.eclipse.sensinact.gateway.app.manager.component.data.ConstantData;
import org.eclipse.sensinact.gateway.app.manager.component.data.ResourceData;
import org.eclipse.sensinact.gateway.app.manager.component.property.AbstractPropertyBlock;
import org.eclipse.sensinact.gateway.app.manager.json.AppParameter;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.osgi.framework.ServiceReference;

public class Component
implements DataListenerItf,
FunctionUpdateListener {
    private final AppServiceMediator mediator;
    private final String identifier;
    private final Map<String, DataProviderSubscription> inputDataProviderMap;
    private final AbstractFunction<?> function;
    private final List<AppParameter> functionParameters;
    private final Map<String, AbstractPropertyBlock> propertyBlocks;
    private final Map<String, DataProvider> outputDataProviderMap;
    private Session session;
    private Event lastEvent;

    public Component(AppServiceMediator mediator, String identifier, Map<String, DataProviderSubscription> inputDataProviderMap, AbstractFunction<?> function, List<AppParameter> functionParameters, Map<String, AbstractPropertyBlock> propertyBlocks, Map<String, DataProvider> outputDataProviderMap) {
        this.mediator = mediator;
        this.identifier = identifier;
        this.inputDataProviderMap = inputDataProviderMap;
        this.functionParameters = functionParameters;
        this.function = function;
        this.propertyBlocks = propertyBlocks;
        this.outputDataProviderMap = outputDataProviderMap;
    }

    public void instantiate(Session session) throws LifeCycleException, ApplicationRuntimeException {
        if (session == null) {
            throw new ApplicationRuntimeException("User session does not exist");
        }
        this.session = session;
        for (Map.Entry<String, DataProviderSubscription> entry : this.inputDataProviderMap.entrySet()) {
            DataProviderSubscription subscription = entry.getValue();
            try {
                String filter = "(&(objectClass=" + DataProviderItf.class.getName() + ")(uri=" + subscription.getDataProviderUri() + "))";
                ServiceReference<?>[] serviceReferences = this.mediator.getServiceReferences(filter);
                if (serviceReferences.length == 0) {
                    throw new LifeCycleException("Unable to find " + subscription.getDataProviderUri() + ". No service registered.");
                }
                for (ServiceReference<?> serviceReference : serviceReferences) {
                    DataProviderItf dataProviderItf = (DataProviderItf)this.mediator.getService(serviceReference);
                    dataProviderItf.addListener(this, subscription.getConstraints());
                }
            }
            catch (Exception e) {
                throw new LifeCycleException("Unable to instantiate the component " + this.identifier + " > " + e.getMessage());
            }
        }
        this.function.instantiate();
        this.function.setListener(this);
        for (Map.Entry<String, Object> entry : this.propertyBlocks.entrySet()) {
            ((AbstractPropertyBlock)entry.getValue()).instantiate();
        }
    }

    public void uninstantiate() throws LifeCycleException {
        for (Map.Entry<String, DataProviderSubscription> entry : this.inputDataProviderMap.entrySet()) {
            DataProviderSubscription subscription = entry.getValue();
            try {
                String filter = "(&(objectClass=" + DataProviderItf.class.getName() + ")(uri=" + subscription.getDataProviderUri() + "))";
                ServiceReference[] serviceReferences = this.mediator.getContext().getServiceReferences((String)null, filter);
                if (serviceReferences.length == 0) {
                    throw new LifeCycleException("Unable to find " + subscription.getDataProviderUri() + ". No service registered.");
                }
                for (ServiceReference serviceReference : serviceReferences) {
                    DataProviderItf dataProviderItf = (DataProviderItf)this.mediator.getService(serviceReference);
                    dataProviderItf.removeListener(this);
                }
            }
            catch (Exception e) {
                throw new LifeCycleException("Unable to uninstantiate the component " + this.identifier + " > " + e.getMessage());
            }
        }
        this.function.removeListener(this);
        this.function.uninstantiate();
        for (Map.Entry<String, Object> entry : this.propertyBlocks.entrySet()) {
            ((AbstractPropertyBlock)entry.getValue()).uninstantiate();
        }
        this.session = null;
    }

    @Override
    public void eventNotification(Event event) {
        List<String> eventRoute = event.getRoute();
        String firstProvider = eventRoute.get(0);
        String lastProvider = eventRoute.get(eventRoute.size() - 1);
        UUID eventUUID = event.getUuid();
        HashMap<String, UUID> lastUuidPerRoute = new HashMap<String, UUID>();
        lastUuidPerRoute.put(lastProvider, eventUUID);
        for (Map.Entry<String, DataProviderSubscription> map : this.inputDataProviderMap.entrySet()) {
            if (map.getKey().equals(event.getData().getSourceUri())) continue;
            List<List<String>> listenerRoutes = ((DataProviderSubscription)map.getValue()).getRoutes();
            for (List<String> listenerRoute : listenerRoutes) {
                if (!listenerRoute.get(0).equals(firstProvider) || listenerRoute.get(listenerRoute.size() - 1).equals(lastProvider) || !lastUuidPerRoute.containsKey(map.getKey()) || ((UUID)lastUuidPerRoute.get(((DataProviderSubscription)map.getValue()).getDataProviderUri())).compareTo(eventUUID) == 0) continue;
                return;
            }
        }
        this.lastEvent = event;
        ArrayList<DataItf> dataList = new ArrayList<DataItf>();
        for (AppParameter parameter : this.functionParameters) {
            ServiceReference<?>[] serviceReferences;
            String filter;
            DataItf data = null;
            if (parameter.getType().equals("resource")) {
                data = new ResourceData(this.session, (String)parameter.getValue());
            } else if (parameter.getType().equals("variable")) {
                filter = "(&(objectClass=" + DataProviderItf.class.getName() + ")(uri=" + parameter.getValue() + "))";
                serviceReferences = this.mediator.getServiceReferences(filter);
                data = ((DataProviderItf)this.mediator.getService(serviceReferences[0])).getData();
            } else if (parameter.getType().equals("event")) {
                if (event.getData().getSourceUri().matches((String)parameter.getValue())) {
                    data = event.getData();
                } else {
                    filter = "(&(objectClass=" + DataProviderItf.class.getName() + ")(uri=" + parameter.getValue() + "))";
                    serviceReferences = this.mediator.getServiceReferences(filter);
                    data = ((DataProviderItf)this.mediator.getService(serviceReferences[0])).getData();
                }
            } else if (CastUtils.jsonTypeToJavaType((String)parameter.getType()) != null) {
                data = new ConstantData(parameter.getValue(), CastUtils.jsonTypeToJavaType((String)parameter.getType()));
            }
            dataList.add(data);
        }
        try {
            this.function.process(dataList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatedResult(Object result) {
        UUID uuid = this.lastEvent.getUuid();
        List<String> sources = this.lastEvent.getRoute();
        if (this.function.isAsynchronous()) {
            uuid = UUID.randomUUID();
            sources = new ArrayList<String>();
        }
        try {
            this.outputDataProviderMap.get("result").updateAndNotify(uuid, result, sources);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AbstractPropertyBlock getProperty(String property) {
        return this.propertyBlocks.get(property);
    }

    public List<AppParameter> getFunctionParameters() {
        return this.functionParameters;
    }
}

