/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.factory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.api.exception.ApplicationFactoryException;
import org.eclipse.sensinact.gateway.app.api.function.AbstractFunction;
import org.eclipse.sensinact.gateway.app.manager.component.Component;
import org.eclipse.sensinact.gateway.app.manager.component.DataProvider;
import org.eclipse.sensinact.gateway.app.manager.component.DataProviderSubscription;
import org.eclipse.sensinact.gateway.app.manager.component.property.AbstractPropertyBlock;
import org.eclipse.sensinact.gateway.app.manager.json.AppParameter;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;

class ComponentBuilder {
    private final AppServiceMediator mediator;
    private final String identifier;
    private final AbstractFunction<?> function;
    private final Map<String, DataProvider> dataProviderMap;
    private Map<String, DataProviderSubscription> abstractDataListenerMap;
    private List<AppParameter> parameters;
    private Map<String, AbstractPropertyBlock> propertyBlocks;

    ComponentBuilder(AppServiceMediator mediator, String identifier, AbstractFunction<?> function, List<AppParameter> parameters, Map<String, DataProvider> dataProviderMap) {
        this.mediator = mediator;
        this.identifier = identifier;
        this.function = function;
        this.parameters = parameters;
        this.dataProviderMap = dataProviderMap;
        this.abstractDataListenerMap = new HashMap<String, DataProviderSubscription>();
        this.propertyBlocks = new HashMap<String, AbstractPropertyBlock>();
    }

    ComponentBuilder addEvent(String source, DataProviderSubscription subscription) {
        this.abstractDataListenerMap.put(source, subscription);
        return this;
    }

    ComponentBuilder addProperty(String property, AbstractPropertyBlock propertyBlock) {
        this.propertyBlocks.put(property, propertyBlock);
        return this;
    }

    public Component build() throws ApplicationFactoryException {
        if (this.function == null) {
            throw new ApplicationFactoryException("Function is not defined");
        }
        if (this.abstractDataListenerMap.isEmpty()) {
            throw new ApplicationFactoryException("No listeners set in the component");
        }
        return new Component(this.mediator, this.identifier, this.abstractDataListenerMap, this.function, this.parameters, this.propertyBlocks, this.dataProviderMap);
    }
}

