/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.internal;

import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.api.persistence.ApplicationPersistenceService;
import org.eclipse.sensinact.gateway.app.api.persistence.listener.ApplicationAvailabilityListenerAbstract;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.app.manager.internal.AppInstallExecutor;
import org.eclipse.sensinact.gateway.app.manager.internal.AppJsonSchemaListener;
import org.eclipse.sensinact.gateway.app.manager.internal.AppUninstallExecutor;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceException;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.ModelInstanceBuilder;
import org.eclipse.sensinact.gateway.core.PropertyResource;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppManagerFactory
extends ApplicationAvailabilityListenerAbstract {
    private static Logger LOG = LoggerFactory.getLogger(AppManagerFactory.class);
    private final ModelInstance<ModelConfiguration> modelInstance;
    private final ServiceProviderImpl serviceProvider;
    private final AppJsonSchemaListener jsonSchemaListener;
    private final ApplicationPersistenceService persistenceService;
    private AppInstallExecutor installExecutor;
    private AppUninstallExecutor uninstallExecutor;

    public AppManagerFactory(AppServiceMediator mediator, ApplicationPersistenceService persistenceService) throws InvalidResourceException, InvalidServiceProviderException, InvalidServiceException, InvalidValueException {
        this.persistenceService = persistenceService;
        ModelConfiguration config = new ModelConfigurationBuilder((Mediator)mediator, ModelConfiguration.class, ModelInstance.class).withStartAtInitializationTime(true).build(new Object[0]);
        this.modelInstance = new ModelInstanceBuilder((Mediator)mediator).build("AppManager", null, config);
        this.modelInstance.configuration().setServiceImplmentationType(ApplicationService.class);
        this.serviceProvider = this.modelInstance.getRootElement();
        ServiceImpl adminService = this.serviceProvider.getAdminService();
        ResourceImpl installResource = adminService.addActionResource("INSTALL", ActionResource.class);
        AccessMethod.Type act = AccessMethod.Type.valueOf((String)AccessMethod.ACT);
        this.installExecutor = new AppInstallExecutor(mediator, this.serviceProvider, persistenceService);
        installResource.registerExecutor(new Signature((Mediator)mediator, act, new Class[]{String.class, JSONObject.class}, null), (AccessMethodExecutor)this.installExecutor, AccessMethodExecutor.ExecutionPolicy.AFTER);
        ResourceImpl uninstallResource = adminService.addActionResource("UNINSTALL", ActionResource.class);
        this.uninstallExecutor = new AppUninstallExecutor(this.serviceProvider, persistenceService);
        uninstallResource.registerExecutor(new Signature((Mediator)mediator, act, new Class[]{String.class}, null), (AccessMethodExecutor)this.uninstallExecutor, AccessMethodExecutor.ExecutionPolicy.AFTER);
        ResourceImpl resource = adminService.addDataResource(PropertyResource.class, "available_functions", JSONArray.class, null);
        this.jsonSchemaListener = new AppJsonSchemaListener(mediator, resource);
        this.persistenceService.registerServiceAvailabilityListener(this.uninstallExecutor);
        this.persistenceService.registerServiceAvailabilityListener(this.installExecutor);
    }

    public void deleteAppManager() throws Exception {
        this.deleteApplication(null);
        this.modelInstance.unregister();
        this.jsonSchemaListener.stop();
    }

    public void deleteApplication(String name) throws Exception {
        for (ServiceImpl service : this.serviceProvider.getServices()) {
            if (!(service instanceof ApplicationService)) continue;
            ApplicationService applicationContainer = (ApplicationService)service;
            if (name != null && !applicationContainer.getApplication().getName().equals(name)) continue;
            applicationContainer.getApplication().stop();
        }
    }

    private ApplicationService getApplicationService(String name) {
        for (ServiceImpl service : this.serviceProvider.getServices()) {
            if (!(service instanceof ApplicationService)) continue;
            ApplicationService applicationContainer = (ApplicationService)service;
            if (name == null || !applicationContainer.getApplication().getName().equals(name)) continue;
            return applicationContainer;
        }
        return null;
    }

    @Override
    public void applicationFound(String applicationName, String content) {
        try {
            LOG.info("Installing new application '{}'", (Object)applicationName);
            this.installExecutor.install(applicationName, new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value"));
        }
        catch (Exception e) {
            LOG.error("Failed to install application '{}'", (Object)applicationName, (Object)e);
        }
    }

    @Override
    public void applicationChanged(String applicationName, String content) {
        try {
            LOG.info("Updating application content '{}'", (Object)applicationName);
            ApplicationService as = this.getApplicationService(applicationName);
            as.getApplication().stop();
            as.getResource("status").getAttribute("value").setValue((Object)ApplicationStatus.INSTALLED);
            as.stop();
            this.installExecutor.install(applicationName, new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value"));
        }
        catch (Exception e) {
            LOG.error("Failed to uninstall application {}", (Object)applicationName, (Object)e);
        }
    }

    @Override
    public void applicationRemoved(String applicationName) {
        try {
            LOG.info("Removing application '{}'", (Object)applicationName);
            ApplicationService as = this.getApplicationService(applicationName);
            as.getResource("status").getAttribute("value").setValue((Object)ApplicationStatus.UNINSTALLED);
            as.getApplication().stop();
            as.getApplication().uninstall();
            as.stop();
        }
        catch (Exception e) {
            LOG.error("Failed to uninstall application", (Object)applicationName, (Object)e);
        }
    }
}

