/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.json;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.app.api.exception.FunctionNotFoundException;
import org.eclipse.sensinact.gateway.app.manager.json.AppEvent;
import org.eclipse.sensinact.gateway.app.manager.json.AppFunction;
import org.eclipse.sensinact.gateway.app.manager.json.ComponentProperties;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppComponent
implements JSONable {
    private final String identifier;
    private final List<AppEvent> events;
    private final AppFunction function;
    private final ComponentProperties properties;

    public AppComponent(String identifier, List<AppEvent> events, AppFunction function, ComponentProperties properties) throws FunctionNotFoundException {
        this.identifier = identifier;
        this.events = events;
        this.function = function;
        this.properties = properties;
    }

    public AppComponent(AppServiceMediator mediator, JSONObject component) throws FunctionNotFoundException {
        JSONObject propertiesJson;
        this.identifier = component.getString("identifier");
        this.events = new ArrayList<AppEvent>();
        JSONArray eventArray = component.getJSONArray("events");
        for (int i = 0; i < eventArray.length(); ++i) {
            this.events.add(new AppEvent(mediator, eventArray.getJSONObject(i)));
        }
        this.function = new AppFunction(component.getJSONObject("function"));
        ComponentProperties.Builder propertiesBuilder = new ComponentProperties.Builder();
        if (component.has("properties") && (propertiesJson = component.getJSONObject("properties")).has("register")) {
            propertiesBuilder.register(propertiesJson.getBoolean("register"));
        }
        this.properties = propertiesBuilder.build();
    }

    public List<AppEvent> getEvents() {
        return this.events;
    }

    public AppFunction getFunction() {
        return this.function;
    }

    public ComponentProperties getProperties() {
        return this.properties;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getJSON() {
        JSONObject component = new JSONObject();
        component.put("identifier", (Object)this.identifier);
        JSONArray eventArray = new JSONArray();
        for (AppEvent event : this.events) {
            eventArray.put((Object)event.getJSON());
        }
        component.put("events", (Object)eventArray);
        component.put("function", (Object)this.function.getJSON());
        component.put("properties", (Object)this.properties.getJSON());
        return component.toString();
    }
}

