/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.storage.influxdb.write;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.sensinact.gateway.historic.storage.agent.generic.StorageConnection;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDbDatabase;
import org.eclipse.sensinact.gateway.util.json.JSONObjectStatement;
import org.eclipse.sensinact.gateway.util.json.JSONTokenerStatement;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBStorageConnection
extends StorageConnection {
    Logger LOGGER = LoggerFactory.getLogger(InfluxDBStorageConnection.class);
    private static final String STORAGE_AGENT_INFLUXDB_FIELDS = "org.eclipse.sensinact.gateway.history.influxdb.fields";
    private static final String STORAGE_AGENT_INFLUXDB_TAGS = "org.eclipse.sensinact.gateway.history.influxdb.tags";
    private static final String STORAGE_AGENT_INFLUXDB_ENABLE_DEFAULT = "org.eclipse.sensinact.gateway.history.influxdb.default";
    private static final String STORAGE_AGENT_INFLUXDB_ENABLE_GEOJSON = "org.eclipse.sensinact.gateway.history.influxdb.geojson";
    private static final JSONObjectStatement STATEMENT = new JSONObjectStatement(new JSONTokenerStatement("{ \"type\": \"Feature\", \"properties\": {},  \"geometry\": {     \"type\": \"Point\",     \"coordinates\": [ $(longitude),$(latitude)]   }}"));
    private String measurement;
    private InfluxDbDatabase database;
    private boolean enableGeoJSON;
    private boolean enableDefault;
    private Set<String> fields;
    private Set<String> tags;

    public InfluxDBStorageConnection(InfluxDbDatabase database, String measurement, Dictionary<String, ?> props) {
        this.database = database;
        this.measurement = measurement;
        this.enableDefault = true;
        this.enableGeoJSON = false;
        Object fieldsProperty = props.get(STORAGE_AGENT_INFLUXDB_FIELDS);
        Object tagsProperty = props.get(STORAGE_AGENT_INFLUXDB_TAGS);
        Object defaultProperty = props.get(STORAGE_AGENT_INFLUXDB_ENABLE_DEFAULT);
        Object geojsonProperty = props.get(STORAGE_AGENT_INFLUXDB_ENABLE_GEOJSON);
        this.fields = new HashSet<String>();
        this.tags = new HashSet<String>();
        if (geojsonProperty != null) {
            this.enableGeoJSON = Boolean.parseBoolean(String.valueOf(geojsonProperty));
        }
        if (defaultProperty != null) {
            this.enableDefault = Boolean.parseBoolean(String.valueOf(defaultProperty));
        }
        if (this.enableDefault) {
            this.fields.add("latitude");
            this.fields.add("longitude");
            this.tags.add("path");
            this.tags.add("resource");
        }
        if (this.enableGeoJSON) {
            this.fields.add("geojson");
        }
        if (fieldsProperty != null) {
            String[] fieldsArr;
            String fieldsStr = String.valueOf(fieldsProperty);
            for (String field : fieldsArr = fieldsStr.split(",")) {
                String fd = field.trim();
                if (fd.length() <= 0) continue;
                this.fields.add(fd);
            }
        }
        if (tagsProperty != null) {
            String[] tagsArr;
            String tagsStr = String.valueOf(tagsProperty);
            for (String tag : tagsArr = tagsStr.split(",")) {
                String tg = tag.trim();
                if (tg.length() <= 0) continue;
                this.tags.add(tg);
            }
        }
    }

    public void store(JSONObject obj) {
        String measurement = null;
        Hashtable<String, Object> fs = new Hashtable<String, Object>();
        Hashtable<String, String> ts = new Hashtable<String, String>();
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (this.fields.contains(key)) {
                ((Dictionary)fs).put(key, obj.get(key));
                continue;
            }
            if (!this.tags.contains(key)) continue;
            ((Dictionary)ts).put(key, String.valueOf(obj.get(key)));
        }
        this.extractLocation(fs, obj.opt("location"));
        Object o = obj.opt("value");
        Object value = null;
        if (o != null) {
            if (o.getClass().isPrimitive()) {
                value = String.valueOf(o);
                if (o.getClass() != Character.TYPE && o.getClass() != Boolean.TYPE) {
                    value = Double.parseDouble((String)value);
                }
            } else {
                value = o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : String.valueOf(o);
            }
        }
        measurement = value == null ? this.measurement : (value.getClass() == String.class ? this.measurement.concat("_str") : this.measurement.concat("_num"));
        long tm = obj.optLong("timestamp");
        long timestamp = 0L;
        timestamp = tm > 0L ? tm : System.currentTimeMillis();
        if (!((Dictionary)ts).isEmpty()) {
            this.database.add(measurement, ts, fs, value, timestamp);
        }
    }

    private void extractLocation(Dictionary<String, Object> fields, Object location) {
        int ind;
        if (location == null) {
            return;
        }
        double latitude = -1.0;
        double longitude = -1.0;
        String geolocation = null;
        String lc = String.valueOf(location);
        String[] separators = new String[]{":", ",", ".", "-", " "};
        for (ind = 0; ind < separators.length && lc.indexOf(separators[ind]) <= -1; ++ind) {
        }
        if (ind >= separators.length) {
            return;
        }
        String separator = separators[ind];
        String[] locationElements = lc.split(separator);
        if (locationElements.length == 2) {
            try {
                latitude = Double.parseDouble(locationElements[0]);
                longitude = Double.parseDouble(locationElements[1]);
                if (this.enableDefault) {
                    fields.put("latitude", latitude);
                    fields.put("longitude", longitude);
                }
                STATEMENT.apply("latitude", (Object)latitude);
                STATEMENT.apply("longitude", (Object)longitude);
                geolocation = STATEMENT.toString();
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            geolocation = lc;
        }
        if (this.enableGeoJSON && geolocation != null) {
            fields.put("geolocation", geolocation);
        }
    }
}

