/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragment;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragmentImpl;
import org.eclipse.sensinact.gateway.generic.packet.PayloadResourceFragment;
import org.eclipse.sensinact.gateway.generic.packet.PayloadResourceFragmentImpl;
import org.eclipse.sensinact.gateway.generic.packet.PayloadServiceFragmentImpl;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.packet.TaskAwareHttpResponsePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpDevicePacketReader
implements PacketReader<TaskAwareHttpResponsePacket>,
Iterator<PayloadFragment> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpDevicePacketReader.class);
    private static final String TIMESTAMP = "::timestamp::";
    private static final String PROVIDER_IDENTIFIER = "::provider::";
    private static final String CONCATENATION_FUNCTION_REGEX = "\\$(concat)\\(([^,]+(,[^,]+)+)\\)";
    private static final String LITERAL_FUNCTION_REGEX = "^\\$(literal)\\((.+)\\)$";
    private static final Pattern CONCATENATION_FUNCTION_PATTERN = Pattern.compile("\\$(concat)\\(([^,]+(,[^,]+)+)\\)");
    private static final Pattern LITERAL_FUNCTION_PATTERN = Pattern.compile("^\\$(literal)\\((.+)\\)$");
    private final SimpleDateFormat timestampFormat;
    private final String serviceProviderIdPattern;

    public AbstractHttpDevicePacketReader(SimpleDateFormat timestampFormat, String serviceProviderIdPattern) {
        this.timestampFormat = timestampFormat;
        this.serviceProviderIdPattern = serviceProviderIdPattern;
    }

    public Iterator<PayloadFragment> iterator() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String substitute(Map<String, Object> data, Map<String, String> mapping, String expression) {
        String variable = expression;
        int startVariable = variable.indexOf("${");
        int endVariable = variable.indexOf("}");
        if (startVariable <= -1) return variable;
        if (endVariable <= -1) return variable;
        if (endVariable <= startVariable) return variable;
        try {
            Function<Object, String> transform;
            String searchVariable;
            String pathVariable = variable.substring(startVariable + 2, endVariable);
            if (pathVariable.indexOf(58) >= 0) {
                String[] split = pathVariable.split(":");
                searchVariable = split[0];
                int start = Integer.parseInt(split[1]);
                if (split.length == 2) {
                    transform = o -> o == null ? "null" : String.valueOf(o).substring(start);
                } else {
                    if (split.length != 3) {
                        LOG.error("Unable to validate variable {}", (Object)pathVariable);
                        throw new IllegalArgumentException("The variable " + pathVariable + " is not valid");
                    }
                    transform = o -> o == null ? "null" : String.valueOf(o).substring(start, start + Integer.parseInt(split[2]));
                }
            } else {
                searchVariable = pathVariable;
                transform = String::valueOf;
            }
            String key = this.findKeyForValue(mapping, String.format("__%s", searchVariable));
            String pathResult = transform.apply(this.getFromDataMap(data, key));
            return String.format("%s%s%s", expression.substring(0, startVariable), pathResult, expression.substring(endVariable + 1));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return variable;
    }

    private Object resolveValue(Map<String, Object> data, Map<String, String> mapping, String key) {
        Matcher matcher = CONCATENATION_FUNCTION_PATTERN.matcher(key);
        if (matcher.matches()) {
            String argument = matcher.group(2);
            String[] arguments = argument.split(",");
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < arguments.length; ++i) {
                String arg = arguments[i];
                if (arg.charAt(0) == '\'' && arg.charAt(arg.length() - 1) == '\'') {
                    builder.append(arg.substring(1, arg.length() - 1));
                    continue;
                }
                builder.append(this.substitute(data, mapping, arguments[i]).trim());
            }
            return builder.toString();
        }
        matcher = LITERAL_FUNCTION_PATTERN.matcher(key);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return this.getFromDataMap(data, key);
    }

    private String buildProviderId(Map<String, Object> data, Map<String, String> mapping) {
        String providerIdentifier = null;
        String path = this.findKeyForValue(mapping, PROVIDER_IDENTIFIER);
        if (path != null) {
            providerIdentifier = String.valueOf(this.resolveValue(data, mapping, path));
        }
        return providerIdentifier;
    }

    private long resolveTimestamp(Map<String, Object> data, Map<String, String> mapping) {
        long l = 0L;
        String timestampPath = this.findKeyForValue(mapping, TIMESTAMP);
        if (timestampPath == null) {
            return l;
        }
        Object resultTimestamp = this.resolveValue(data, mapping, timestampPath);
        if (resultTimestamp != null) {
            if (this.timestampFormat != null) {
                try {
                    Date d = this.timestampFormat.parse(String.valueOf(resultTimestamp));
                    l = d.getTime();
                }
                catch (ParseException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            } else {
                try {
                    l = Long.parseLong(String.valueOf(resultTimestamp));
                    String lstr = String.valueOf(l);
                    switch (lstr.length()) {
                        case 10: {
                            l *= 1000L;
                        }
                        case 13: {
                            break;
                        }
                        case 16: {
                            l /= 1000L;
                            break;
                        }
                        case 19: {
                            l /= 1000000L;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return l;
    }

    private String findKeyForValue(Map<String, String> map, String value) {
        return map.entrySet().stream().filter(e -> ((String)e.getValue()).equals(value)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private Object getFromDataMap(Map<String, Object> data, String key) {
        String[] keys = key.split("/");
        Object result = data;
        for (String k : keys) {
            if (k.charAt(0) == '[' && k.charAt(k.length() - 1) == ']') {
                if (result instanceof List) {
                    result = ((List)result).get(Integer.parseInt(k.substring(1, k.length() - 1)));
                    continue;
                }
                if (result instanceof Map) {
                    result = ((Map)result).get(k);
                    continue;
                }
                result = null;
                continue;
            }
            if (result instanceof Map) {
                result = result.get(k);
                continue;
            }
            result = null;
            break;
        }
        return result;
    }

    protected PayloadFragment createFragments(Map<String, Object> data, Map<String, String> mapping) {
        String providerId = this.buildProviderId(data, mapping);
        String serviceProviderId = this.serviceProviderIdPattern == null ? providerId : String.format(this.serviceProviderIdPattern, providerId);
        long timestamp = this.resolveTimestamp(data, mapping);
        List serviceFragments = mapping.entrySet().stream().filter(e -> {
            String value = (String)e.getValue();
            return !TIMESTAMP.equals(value) && !value.startsWith(PROVIDER_IDENTIFIER) && !value.startsWith("__");
        }).map(e -> {
            Object value = this.resolveValue(data, mapping, (String)e.getKey());
            String path = this.substitute(data, mapping, (String)e.getValue());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String[] pathElements = path.split("/");
            String serviceId = pathElements[0];
            String resourceId = pathElements[1];
            String attributeId = null;
            String metadataId = null;
            if (pathElements.length > 2) {
                attributeId = pathElements[2];
            }
            if (pathElements.length > 3) {
                metadataId = pathElements[3];
            }
            PayloadServiceFragmentImpl payloadFragment = new PayloadServiceFragmentImpl();
            payloadFragment.setServiceId(serviceId);
            payloadFragment.setResourceId(resourceId);
            if (attributeId != null || value != null) {
                PayloadResourceFragmentImpl payloadAttributeFragment = new PayloadResourceFragmentImpl(attributeId, metadataId, value);
                payloadAttributeFragment.setTimestamp(timestamp);
                payloadFragment.addPayloadAttributeFragment((PayloadResourceFragment)payloadAttributeFragment);
            }
            return payloadFragment;
        }).collect(Collectors.toList());
        PayloadFragmentImpl subPacket = new PayloadFragmentImpl(serviceFragments);
        subPacket.setServiceProviderIdentifier(serviceProviderId);
        subPacket.isGoodbyeMessage(false);
        subPacket.isHelloMessage(false);
        return subPacket;
    }

    protected void safeClose(AutoCloseable toClose) {
        try {
            toClose.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

