/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.xml;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractContentHandler<T>
implements ContentHandler {
    protected static final Logger LOGGER = Logger.getLogger(AbstractContentHandler.class.getCanonicalName());
    protected StringBuilder textContent = new StringBuilder();
    protected Stack<T> stack = null;

    public abstract T end(String var1, String var2) throws SAXException;

    public abstract T start(String var1, String var2, Attributes var3) throws SAXException;

    @Override
    public void characters(char[] chrs, int start, int length) throws SAXException {
        this.textContent.append(chrs, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] chrs, int start, int length) throws SAXException {
        this.textContent.append(chrs, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        Object object = null;
        try {
            object = this.start(localName, qname, atts);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
        if (object != null) {
            this.stack.push(object);
        }
        this.textContent = null;
        this.textContent = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        Object object = null;
        try {
            object = this.end(localName, qname);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
        if (object != null) {
            this.stack.push(object);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        LOGGER.log(Level.CONFIG, "Locator defined");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        LOGGER.log(Level.CONFIG, "start prefix mapping : " + prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        LOGGER.log(Level.CONFIG, "end prefix mapping : " + prefix);
    }

    @Override
    public void startDocument() throws SAXException {
        LOGGER.log(Level.CONFIG, "start document parsing");
        this.stack = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
        LOGGER.log(Level.CONFIG, "end document parsing");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        LOGGER.log(Level.CONFIG, "processing instruction : \n\t" + target + " \n\t " + data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        LOGGER.log(Level.CONFIG, "skipped entity : " + name);
    }
}

