/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper;

import java.io.IOException;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.rsa.discovery.zookeeper.publish.PublishingEndpointListener;
import org.apache.aries.rsa.discovery.zookeeper.repository.ZookeeperEndpointRepository;
import org.apache.aries.rsa.discovery.zookeeper.subscribe.EndpointListenerTracker;
import org.apache.aries.rsa.discovery.zookeeper.subscribe.InterestManager;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperDiscovery
implements Watcher,
ManagedService {
    public static final String DISCOVERY_ZOOKEEPER_ID = "org.apache.cxf.dosgi.discovery.zookeeper";
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperDiscovery.class);
    private final BundleContext bctx;
    private PublishingEndpointListener endpointListener;
    private ServiceTracker<?, ?> endpointListenerTracker;
    private InterestManager imManager;
    private ZooKeeper zkClient;
    private boolean closed;
    private boolean started;
    private Dictionary<String, ?> curConfiguration;
    private ZookeeperEndpointRepository repository;

    public ZooKeeperDiscovery(BundleContext bctx) {
        this.bctx = bctx;
    }

    public synchronized void updated(final Dictionary<String, ?> configuration) throws ConfigurationException {
        LOG.debug("Received configuration update for Zookeeper Discovery: {}", configuration);
        if (!ZooKeeperDiscovery.toMap(configuration).equals(ZooKeeperDiscovery.toMap(this.curConfiguration))) {
            this.stop(false);
            this.curConfiguration = configuration;
            if (this.closed || configuration == null) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZooKeeperDiscovery.this.createZookeeper(configuration);
                    }
                    catch (IOException e) {
                        LOG.error("Error starting zookeeper client", (Throwable)e);
                    }
                }
            }).start();
        }
    }

    private synchronized void start() {
        if (this.closed) {
            return;
        }
        if (this.started) {
            LOG.debug("ZookeeperDiscovery already started");
            return;
        }
        LOG.debug("starting ZookeeperDiscovery");
        this.repository = new ZookeeperEndpointRepository(this.zkClient);
        this.endpointListener = new PublishingEndpointListener(this.repository);
        this.endpointListener.start(this.bctx);
        this.imManager = new InterestManager(this.repository);
        this.repository.addListener(this.imManager);
        this.endpointListenerTracker = new EndpointListenerTracker(this.bctx, this.imManager);
        this.endpointListenerTracker.open();
        this.started = true;
    }

    public synchronized void stop(boolean close) {
        if (this.started) {
            LOG.debug("stopping ZookeeperDiscovery");
        }
        this.started = false;
        this.closed |= close;
        if (this.endpointListener != null) {
            this.endpointListener.stop();
        }
        if (this.endpointListenerTracker != null) {
            this.endpointListenerTracker.close();
        }
        if (this.imManager != null) {
            this.imManager.close();
        }
        if (this.zkClient != null) {
            try {
                this.zkClient.close();
            }
            catch (InterruptedException e) {
                LOG.error("Error closing ZooKeeper", (Throwable)e);
            }
        }
    }

    protected ZooKeeper createZooKeeper(String host, String port, int timeout) throws IOException {
        LOG.info("ZooKeeper discovery connecting to {}:{} with timeout {}", new Object[]{host, port, timeout});
        return new ZooKeeper(host + ":" + port, timeout, (Watcher)this);
    }

    public void process(WatchedEvent event) {
        LOG.debug("got ZooKeeper event " + event);
        switch (event.getState()) {
            case SyncConnected: {
                LOG.info("Connection to ZooKeeper established");
                this.start();
                break;
            }
            case Expired: {
                LOG.info("Connection to ZooKeeper expired. Trying to create a new connection");
                this.stop(false);
                try {
                    this.createZookeeper(this.curConfiguration);
                }
                catch (IOException e) {
                    LOG.error("Error starting zookeeper client", (Throwable)e);
                }
                break;
            }
        }
    }

    private void createZookeeper(Dictionary<String, ?> config) throws IOException {
        String host = (String)this.getWithDefault(config, "zookeeper.host", "localhost");
        String port = (String)this.getWithDefault(config, "zookeeper.port", "2181");
        int timeout = Integer.parseInt((String)this.getWithDefault(config, "zookeeper.timeout", "3000"));
        this.waitPort(host, Integer.parseInt(port));
        this.zkClient = this.createZooKeeper(host, port, timeout);
    }

    private void waitPort(String host, int port) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 2000L) {
            try {
                Socket socket = new Socket(host, port);
                Throwable throwable = null;
                if (socket != null) {
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        socket.close();
                    }
                }
                return;
            }
            catch (IOException e) {
                this.safeSleep();
            }
        }
    }

    private void safeSleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Object getWithDefault(Dictionary<String, ?> config, String key, Object defaultValue) {
        Object value = config.get(key);
        return value != null ? value : defaultValue;
    }

    public static <K, V> Map<K, V> toMap(Dictionary<K, V> dict) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (dict != null) {
            Enumeration<K> keys = dict.keys();
            while (keys.hasMoreElements()) {
                K key = keys.nextElement();
                map.put(key, dict.get(key));
            }
        }
        return map;
    }
}

