/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.listener;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.listener.MqttTopicMessage;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnActivationPayload;
import org.eclipse.sensinact.gateway.sthbnd.ttn.packet.TtnActivationPacket;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtnActivationListener
extends MqttTopicMessage {
    private static final Logger LOG = LoggerFactory.getLogger(TtnActivationListener.class);
    private final Mediator mediator;
    private final MqttProtocolStackEndpoint endpoint;

    public TtnActivationListener(Mediator mediator, MqttProtocolStackEndpoint endpoint) {
        this.mediator = mediator;
        this.endpoint = endpoint;
    }

    public void messageReceived(String topic, String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Activation message: " + message);
        }
        String device = topic.split("/")[2];
        JSONObject json = new JSONObject(message);
        TtnActivationPayload payload = null;
        try {
            payload = new TtnActivationPayload(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (payload != null) {
            TtnActivationPacket packet = new TtnActivationPacket(device, payload.getSubPackets());
            try {
                this.endpoint.process((Packet)packet);
            }
            catch (InvalidPacketException e) {
                e.printStackTrace();
            }
        }
    }
}

