/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnMetadata;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnPacketPayload;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnSubPacket;
import org.eclipse.sensinact.gateway.sthbnd.ttn.packet.PayloadDecoder;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TtnUplinkPayload
extends TtnPacketPayload {
    private static final String PAYLOAD_DECODER = "(objectClass=" + PayloadDecoder.class.getCanonicalName() + ")";
    private final Mediator mediator;
    private final String applicationId;
    private final String deviceId;
    private final String hardwareSerial;
    private final int port;
    private final int counter;
    private final boolean confirmed;
    private final boolean isRetry;
    private final String payloadRaw;
    private final TtnMetadata metadata;

    public TtnUplinkPayload(Mediator mediator, String applicationId, String deviceId, String hardwareSerial, int port, int counter, boolean confirmed, boolean isRetry, String payloadRaw, TtnMetadata metadata) {
        this.mediator = mediator;
        this.applicationId = applicationId;
        this.deviceId = deviceId;
        this.hardwareSerial = hardwareSerial;
        this.port = port;
        this.counter = counter;
        this.confirmed = confirmed;
        this.isRetry = isRetry;
        this.metadata = metadata;
        this.payloadRaw = payloadRaw;
    }

    public TtnUplinkPayload(Mediator mediator, JSONObject json) throws JSONException {
        this.mediator = mediator;
        this.applicationId = json.getString("app_id");
        this.deviceId = json.getString("dev_id");
        this.hardwareSerial = json.getString("hardware_serial");
        this.port = json.getInt("port");
        this.counter = json.getInt("counter");
        this.confirmed = json.optBoolean("confirmed");
        this.isRetry = json.optBoolean("is_retry");
        this.metadata = new TtnMetadata(json.getJSONObject("metadata"));
        this.payloadRaw = json.optString("payload_raw");
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getHardwareSerial() {
        return this.hardwareSerial;
    }

    public int getPort() {
        return this.port;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public String getPayloadRaw() {
        return this.payloadRaw;
    }

    public TtnMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public List<TtnSubPacket<?>> getSubPackets() {
        ArrayList subPackets;
        block9: {
            subPackets = new ArrayList();
            if (this.payloadRaw != null) {
                try {
                    ServiceReference[] serviceReferences = this.mediator.getContext().getServiceReferences((String)null, PAYLOAD_DECODER);
                    if (serviceReferences == null) break block9;
                    for (ServiceReference serviceReference : serviceReferences) {
                        Map<String, Object> decodedPayload = ((PayloadDecoder)this.mediator.getContext().getService(serviceReference)).decodeRawPayload(this.payloadRaw);
                        if (decodedPayload.isEmpty()) continue;
                        for (Map.Entry<String, Object> payloadMap : decodedPayload.entrySet()) {
                            if (payloadMap.getKey().equals("position")) {
                                subPackets.add(new TtnSubPacket<String>("admin", "location", null, null, String.valueOf(payloadMap.getValue())));
                                continue;
                            }
                            if ("#DOWNLINK#".equals(payloadMap.getKey())) {
                                subPackets.add(new TtnSubPacket<Object>(null, null, null, "#DOWNLINK#", payloadMap.getValue()));
                                continue;
                            }
                            String key = payloadMap.getKey();
                            String[] keyElements = UriUtils.getUriElements((String)key);
                            subPackets.add(new TtnSubPacket<String>("content", keyElements[0], keyElements.length > 1 ? keyElements[1] : null, keyElements.length > 2 ? keyElements[2] : null, String.valueOf(payloadMap.getValue())));
                        }
                        break;
                    }
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(subPackets.isEmpty() || subPackets.size() <= 1 && "#DOWNLINK#".equals(((TtnSubPacket)subPackets.get(0)).getMetadata()))) {
            Double frequency = this.metadata.getFrequency();
            if (frequency != null) {
                subPackets.add(new TtnSubPacket<Double>("system", "frequency", null, null, frequency));
            }
            subPackets.add(new TtnSubPacket<String>("system", "modulation", null, null, this.metadata.getModulation()));
            subPackets.add(new TtnSubPacket<String>("system", "data_rate", null, null, this.metadata.getDataRate()));
            subPackets.add(new TtnSubPacket<String>("system", "coding_rate", null, null, this.metadata.getCodingRate()));
            subPackets.add(new TtnSubPacket<String>("system", "data", null, null, this.payloadRaw));
        }
        return subPackets;
    }
}

