/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.security.signature.internal.SignedBundle;
import org.eclipse.sensinact.gateway.util.IOUtils;

public class SignatureBlock
extends CMSSignedData {
    private Mediator mediator;

    public SignatureBlock(Mediator mediator, URL url) throws CMSException, IOException {
        super(IOUtils.read((InputStream)url.openStream()));
        this.mediator = mediator;
    }

    public static SignatureBlock getInstance(Mediator mediator, SignedBundle sjar, String signerName) throws IOException, CMSException {
        SignatureBlock block = null;
        URL rsaEntry = sjar.getEntry("/META-INF/" + signerName + ".RSA");
        URL dsaEntry = sjar.getEntry("/META-INF/" + signerName + ".DSA");
        if (dsaEntry == null) {
            if (rsaEntry != null) {
                block = new SignatureBlock(mediator, rsaEntry);
            }
        } else {
            block = new SignatureBlock(mediator, dsaEntry);
        }
        return block;
    }

    public static byte[] getSignatureFromSignedData(CMSSignedData pkcs7) {
        Iterator<SignerInformation> iter = pkcs7.getSignerInfos().getSigners().iterator();
        byte[] signature = null;
        while (iter.hasNext()) {
            SignerInformation signerInfo = iter.next();
            signature = signerInfo.getSignature();
        }
        return signature;
    }
}

