/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.config;

import io.moquette.server.config.ConfigurationParser;
import io.moquette.server.config.IConfig;
import io.moquette.server.config.IResourceLoader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoaderConfig
extends IConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLoaderConfig.class);
    private final Properties m_properties;
    private final IResourceLoader resourceLoader;

    public ResourceLoaderConfig(IResourceLoader resourceLoader) {
        this(resourceLoader, null);
    }

    public ResourceLoaderConfig(IResourceLoader resourceLoader, String configName) {
        Reader configReader;
        this.resourceLoader = resourceLoader;
        Reader reader = configReader = configName != null ? resourceLoader.loadResource(configName) : resourceLoader.loadDefaultResource();
        if (configReader == null) {
            throw new IllegalArgumentException("Can't locate " + resourceLoader.getName() + " \"" + configName + "\"");
        }
        ConfigurationParser confParser = new ConfigurationParser();
        this.m_properties = confParser.getProperties();
        this.assignDefaults();
        try {
            confParser.parse(configReader);
        }
        catch (ParseException pex) {
            LOG.warn("An error occurred in parsing configuration, fallback on default configuration", (Throwable)pex);
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.m_properties.getProperty(name, defaultValue);
    }

    @Override
    public IResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

