/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty;

import io.moquette.parser.proto.Utils;
import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.parser.proto.messages.ConnectMessage;
import io.moquette.parser.proto.messages.PingRespMessage;
import io.moquette.parser.proto.messages.PubAckMessage;
import io.moquette.parser.proto.messages.PubCompMessage;
import io.moquette.parser.proto.messages.PubRecMessage;
import io.moquette.parser.proto.messages.PubRelMessage;
import io.moquette.parser.proto.messages.PublishMessage;
import io.moquette.parser.proto.messages.SubscribeMessage;
import io.moquette.parser.proto.messages.UnsubscribeMessage;
import io.moquette.server.netty.NettyUtils;
import io.moquette.spi.impl.ProtocolProcessor;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CorruptedFrameException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyMQTTHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NettyMQTTHandler.class);
    private final ProtocolProcessor m_processor;

    public NettyMQTTHandler(ProtocolProcessor processor) {
        this.m_processor = processor;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        AbstractMessage msg = (AbstractMessage)message;
        LOG.info("Received a message of type {}", (Object)Utils.msgType2String(msg.getMessageType()));
        try {
            switch (msg.getMessageType()) {
                case 1: {
                    this.m_processor.processConnect(ctx.channel(), (ConnectMessage)msg);
                    break;
                }
                case 8: {
                    this.m_processor.processSubscribe(ctx.channel(), (SubscribeMessage)msg);
                    break;
                }
                case 10: {
                    this.m_processor.processUnsubscribe(ctx.channel(), (UnsubscribeMessage)msg);
                    break;
                }
                case 3: {
                    this.m_processor.processPublish(ctx.channel(), (PublishMessage)msg);
                    break;
                }
                case 5: {
                    this.m_processor.processPubRec(ctx.channel(), (PubRecMessage)msg);
                    break;
                }
                case 7: {
                    this.m_processor.processPubComp(ctx.channel(), (PubCompMessage)msg);
                    break;
                }
                case 6: {
                    this.m_processor.processPubRel(ctx.channel(), (PubRelMessage)msg);
                    break;
                }
                case 14: {
                    this.m_processor.processDisconnect(ctx.channel());
                    break;
                }
                case 4: {
                    this.m_processor.processPubAck(ctx.channel(), (PubAckMessage)msg);
                    break;
                }
                case 12: {
                    PingRespMessage pingResp = new PingRespMessage();
                    ctx.writeAndFlush(pingResp);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Bad error in processing the message", (Throwable)ex);
            ctx.fireExceptionCaught(ex);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = NettyUtils.clientID(ctx.channel());
        if (clientID != null && !clientID.isEmpty()) {
            this.m_processor.processConnectionLost(clientID, ctx.channel());
        }
        ctx.close();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof CorruptedFrameException) {
            LOG.warn("Error decoding a packet, probably a bad formatted packet, message: " + cause.getMessage());
        } else if (cause instanceof IOException && "Connection reset by peer".equals(cause.getMessage())) {
            LOG.warn("Network connection closed abruptly");
        } else {
            LOG.error("Ugly error on networking", cause);
        }
        ctx.close();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.m_processor.notifyChannelWritable(ctx.channel());
        }
        ctx.fireChannelWritabilityChanged();
    }
}

