/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.perm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class CodeBaseCondition
implements Condition {
    private static final char ESCAPE = '\\';
    private static final char SPACE = ' ';
    private static final char WILDCARD = '*';
    private static final String CONDITION_TYPE = "org.eclipse.sensinact.gateway.core.security.perm.CodeBaseCondition";
    private static final String CODEBASE_SOURCES_TYPE = "org.eclipse.sensinact.gateway.core.security.perm.CodeBaseCondition$1";
    private static CodeBaseSources _sources = null;
    private Bundle bundle;
    private ConditionInfo info;

    static final Bundle findBundle(BundleContext context, String name, boolean location) {
        Bundle bundle = null;
        if (name != null && context != null) {
            int length;
            if (location) {
                bundle = context.getBundle(name);
                if ((((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0 && bundle.getState() == 4) {
                    bundle = CodeBaseCondition.findBundle(context, (String)bundle.getHeaders().get("Fragment-Host"), false);
                }
                return bundle;
            }
            Bundle[] bundles = context.getBundles();
            int n = length = bundles == null ? 0 : bundles.length;
            for (int index = 0; index < length; ++index) {
                Bundle tmp = bundles[index];
                if (!name.equals(tmp.getSymbolicName())) continue;
                if ((((BundleRevision)tmp.adapt(BundleRevision.class)).getTypes() & 1) != 0 && tmp.getState() == 4) {
                    bundle = CodeBaseCondition.findBundle(context, (String)tmp.getHeaders().get("Fragment-Host"), false);
                    break;
                }
                bundle = tmp;
                break;
            }
        }
        return bundle;
    }

    public static Condition getCondition(final Bundle bundle, ConditionInfo info) {
        if (!CONDITION_TYPE.equals(info.getType())) {
            throw new IllegalArgumentException("ConditionInfo must be of type \"org.eclipse.sensinact.gateway.core.security.perm.CodeBaseCondition\"");
        }
        String[] args = info.getArgs();
        if (args.length != 1 && args.length != 2) {
            throw new IllegalArgumentException("Illegal number of args: " + args.length);
        }
        final char[] expected = info.getArgs()[0].toCharArray();
        if (expected.length == 1 && expected[0] == '*') {
            return Condition.TRUE;
        }
        final Condition complies = info.getArgs().length == 2 && "!".equals(info.getArgs()[1]) ? Condition.FALSE : Condition.TRUE;
        Condition uncomplies = complies.equals(Condition.FALSE) ? Condition.TRUE : Condition.FALSE;
        final ConditionWrapper pod = new ConditionWrapper();
        pod.c = uncomplies;
        if (_sources == null) {
            String[] s = info.getArgs()[0].split("\\\\,");
            _sources = new CodeBaseSources((List)Arrays.asList(s), CONDITION_TYPE, CODEBASE_SOURCES_TYPE){};
        }
        _sources.check(CODEBASE_SOURCES_TYPE);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                int length;
                ClassLoader classloader = null;
                Bundle b = null;
                try {
                    b = (((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0 && bundle.getState() == 4 ? CodeBaseCondition.findBundle(bundle.getBundleContext(), (String)bundle.getHeaders().get("Fragment-Host"), false) : bundle;
                    classloader = ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                }
                catch (Exception ex) {
                    classloader = Thread.currentThread().getContextClassLoader();
                }
                StackTraceElement[] stacktraceElements = Thread.currentThread().getStackTrace();
                int n = length = stacktraceElements == null ? 0 : stacktraceElements.length;
                for (int index = 0; index < length; ++index) {
                    StackTraceElement e = stacktraceElements[index];
                    if (_sources.getCache().contains(e.getClassName())) {
                        pod.c = complies;
                        break;
                    }
                    Class<?> c = null;
                    try {
                        char[] ccs;
                        c = classloader.loadClass(e.getClassName());
                        if (c == null || (ccs = c.getProtectionDomain().getCodeSource().getLocation().toString().toCharArray()).length < expected.length) continue;
                        int i = 0;
                        boolean escape = false;
                        while (i < expected.length) {
                            if (expected[i] == ' ') {
                                ++i;
                                continue;
                            }
                            if (!escape && expected[i] == '\\') {
                                ++i;
                                escape = true;
                                continue;
                            }
                            if (!escape && expected[i] == '*') {
                                ++i;
                                break;
                            }
                            if (ccs[i] != expected[i]) {
                                i = 0;
                                break;
                            }
                            ++i;
                            escape = false;
                        }
                        if (i <= 0) continue;
                        _sources.add(e.getClassName());
                        pod.c = complies;
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        return pod.c;
    }

    private CodeBaseCondition() {
    }

    public CodeBaseCondition(Bundle bundle, ConditionInfo info) {
        this.bundle = bundle;
        this.info = info;
    }

    public boolean isPostponed() {
        return false;
    }

    public boolean isSatisfied() {
        return CodeBaseCondition.getCondition(this.bundle, this.info).isSatisfied();
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isSatisfied(Condition[] conditions, Dictionary<Object, Object> context) {
        if (conditions != null && conditions.length > 0) {
            for (Condition condition : conditions) {
                if (condition.isSatisfied()) continue;
                return false;
            }
        }
        return true;
    }

    static abstract class CodeBaseSources {
        final String conditionType;
        final String codeBaseSourcesType;
        final Set<String> sources;
        volatile int outerCount = 0;

        CodeBaseSources(List<String> cache, String conditionType, String codeBaseSourcesType) {
            this.outerCount = cache.size();
            this.sources = new HashSet<String>(cache);
            this.codeBaseSourcesType = codeBaseSourcesType;
            this.conditionType = conditionType;
        }

        final void check(String codeBaseSourcesType) {
            if (!this.codeBaseSourcesType.equals(codeBaseSourcesType) || !this.codeBaseSourcesType.equals(this.getClass().getName()) || this.outerCount != this.sources.size()) {
                throw new SecurityException("Unauthorized modification");
            }
        }

        final Set<String> getCache() {
            return this.sources;
        }

        final boolean add(String s) {
            StackTraceElement[] stackTraceElements;
            boolean caller = false;
            for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
                if (!this.conditionType.equals(stackTraceElement.getClassName())) continue;
                caller = true;
                break;
            }
            if (!caller) {
                throw new SecurityException("Unauthorized modification");
            }
            ++this.outerCount;
            if (!this.sources.add(s)) {
                --this.outerCount;
                return false;
            }
            return true;
        }
    }

    static final class ConditionWrapper {
        Condition c = null;

        ConditionWrapper() {
        }
    }
}

